package ai.digital.config.server.api

import ai.digital.config.server.api.FileExtension.FileExtension
import ai.digital.config.server.api.FilterCondition.FilterCondition
import ai.digital.config.{ConfigFileFilter, ConfigFileMapping}

trait ConfigurationPropertiesService {

  def propertiesStore(configFileFilter: ConfigFileFilter,
                      header: String,
                      properties: Iterable[(String, PropertyValue)],
                      configFileMapping: ConfigFileMapping): Iterable[String]

  def propertiesUpdate(configFileFilter: ConfigFileFilter,
                       properties: Map[String, PropertyValue],
                       configFileMapping: ConfigFileMapping): Iterable[String]

  def propertiesDelete(configFileFilter: ConfigFileFilter,
                       propertyKeys: Set[String],
                       configFileMapping: ConfigFileMapping): Iterable[String]

  def propertiesEncrypt(configFileFilter: ConfigFileFilter,
                        fileExtension: FileExtension,
                        propertyKey: String,
                        conditionType: FilterCondition
                       ): Iterable[String]
}
