package ai.digital.config.server.embedded

import ai.digital.config.ConfigServerProfiles
import ai.digital.config.server.ApplicationConfigFileMappingResolver
import grizzled.slf4j.Logging
import org.springframework.cloud.config.server.EnableConfigServer
import org.springframework.context.annotation.{ComponentScan, Profile}
import jakarta.annotation.PostConstruct
import org.springframework.boot.autoconfigure.AutoConfiguration

@AutoConfiguration
@Profile(Array(ConfigServerProfiles.CONFIG_SERVER))
@EnableConfigServer
@ComponentScan(
  basePackageClasses = Array(classOf[ApplicationConfigFileMappingResolver])
)
class EmbeddedConfigServerAutoconfiguration extends Logging {

  @PostConstruct
  def startClient(): Unit = {
    logger.info("Starting embedded central configuration server")
  }
}
