package ai.digital.config.server.security

import org.springframework.context.annotation.{Bean, Configuration}
import org.springframework.security.config.Customizer.withDefaults
import org.springframework.security.config.annotation.web.builders.HttpSecurity
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity

import org.springframework.security.web.SecurityFilterChain


@Configuration
@EnableWebSecurity
class BasicSecurityConfiguration  {

  @Bean
  @throws[Exception]
  def securityFilterChain(http: HttpSecurity): SecurityFilterChain = {
    http.csrf(csrf => csrf.disable())
    http.authorizeHttpRequests(requests => requests.anyRequest().authenticated())
    http.formLogin(withDefaults())
    http.httpBasic(withDefaults())
    http.build();
  }

}
