/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.configuration.central.deploy;

import ai.digital.configuration.central.deploy.InitialCentralConfigSetup;
import ai.digital.configuration.central.deploy.InitialCentralConfigSetup$DiffResult$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Marker;
import org.springframework.util.StreamUtils;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Using;
import scala.util.Using$;

public final class InitialCentralConfigSetup$
implements Logging {
    public static final InitialCentralConfigSetup$ MODULE$ = new InitialCentralConfigSetup$();
    private static Config xlDeployConf;
    private static final String CENTRAL_CONFIG_PATH;
    private static File CONFIG_FOLDER;
    private static final String REPOSITORY_YAML_NAME;
    private static final String XL_DEPLOY_CONF_NAME;
    private static final Set<String> initialCentralConfFiles;
    private static final Function1<Path, Object> checkMainRepositoryPropertiesNotExist;
    private static transient Logger grizzled$slf4j$Logging$$_logger;
    private static volatile transient boolean bitmap$trans$0;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        CENTRAL_CONFIG_PATH = "centralConfiguration";
        CONFIG_FOLDER = new File("conf");
        REPOSITORY_YAML_NAME = "deploy-repository.yaml";
        XL_DEPLOY_CONF_NAME = "xl-deploy.conf";
        initialCentralConfFiles = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"deploy-artifact-resolver.yaml", "deploy-client.yaml", "deploy-cluster.yaml", "deploy-command-whitelist.yaml", "deploy-db-anonymizer.yaml", "deploy-jmx.yaml", "deploy-metrics.yaml", "deploy-oidc.yaml", "deploy-plugins.yaml", MODULE$.REPOSITORY_YAML_NAME(), "deploy-satellite.yaml", "deploy-secret-complexity.yaml", "deploy-server.yaml", "deploy-task.yaml", "deploy-websockets.yaml", "deploy-caches.yaml"}));
        checkMainRepositoryPropertiesNotExist = (Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)InitialCentralConfigSetup$.$anonfun$checkMainRepositoryPropertiesNotExist$1(path));
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        InitialCentralConfigSetup$ initialCentralConfigSetup$ = this;
        synchronized (initialCentralConfigSetup$) {
            if (!bitmap$trans$0) {
                grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                bitmap$trans$0 = true;
            }
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : grizzled$slf4j$Logging$$_logger;
    }

    private String CENTRAL_CONFIG_PATH() {
        return CENTRAL_CONFIG_PATH;
    }

    private File CONFIG_FOLDER() {
        return CONFIG_FOLDER;
    }

    private String REPOSITORY_YAML_NAME() {
        return REPOSITORY_YAML_NAME;
    }

    private String XL_DEPLOY_CONF_NAME() {
        return XL_DEPLOY_CONF_NAME;
    }

    private Set<String> initialCentralConfFiles() {
        return initialCentralConfFiles;
    }

    private Config xlDeployConf$lzycompute() {
        InitialCentralConfigSetup$ initialCentralConfigSetup$ = this;
        synchronized (initialCentralConfigSetup$) {
            if (!bitmap$0) {
                xlDeployConf = new File(this.CONFIG_FOLDER(), this.XL_DEPLOY_CONF_NAME()).exists() ? ConfigFactory.load((String)this.XL_DEPLOY_CONF_NAME()) : ConfigFactory.defaultReference();
                bitmap$0 = true;
            }
        }
        CONFIG_FOLDER = null;
        return xlDeployConf;
    }

    private Config xlDeployConf() {
        return !bitmap$0 ? this.xlDeployConf$lzycompute() : xlDeployConf;
    }

    private Function1<Path, Object> checkMainRepositoryPropertiesNotExist() {
        return checkMainRepositoryPropertiesNotExist;
    }

    public Set<Path> setup() {
        Set<Path> set;
        this.createCentralConfigDir();
        Set<InitialCentralConfigSetup.DiffResult> initialDiffs = this.diffInitialFiles();
        if (initialDiffs.nonEmpty()) {
            this.logger().info((Function0 & Serializable)() -> "Copying central configuration files if necessary.");
            set = this.copyCentralConfigConfToFilesystemBackend(initialDiffs);
        } else {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public Set<Path> copyCentralConfigConfToFilesystemBackend(Set<InitialCentralConfigSetup.DiffResult> diffs) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return (Set)diffs.map((Function1 & Serializable)diff -> (Path)Using$.MODULE$.resource((Object)classLoader.getResourceAsStream(((Object)diff.filePath()).toString().replace("\\", "/")), (Function1 & Serializable)fileStream -> {
            byte[] bytes = StreamUtils.copyToByteArray((InputStream)fileStream);
            return MODULE$.writeToFile(diff.filePath(), bytes, (Seq<OpenOption>)Nil$.MODULE$);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
    }

    private Path writeToFile(Path path, byte[] content, Seq<OpenOption> options) {
        Using$.MODULE$.resource((Object)Files.newOutputStream(path, (OpenOption[])options.toArray(ClassTag$.MODULE$.apply(OpenOption.class))), (Function1 & Serializable)writer -> {
            writer.write(content);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        return path;
    }

    private Set<InitialCentralConfigSetup.DiffResult> diffInitialFiles() {
        Set existingFiles = (Set)((IterableOps)((IterableOps)this.initialCentralConfFiles().map((Function1 & Serializable)x$1 -> Paths.get(MODULE$.CENTRAL_CONFIG_PATH(), x$1))).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)InitialCentralConfigSetup$.$anonfun$diffInitialFiles$2(x$2)))).filter(this.checkMainRepositoryPropertiesNotExist());
        return (Set)existingFiles.map((Function1 & Serializable)x$3 -> new InitialCentralConfigSetup.DiffResult((Path)x$3, InitialCentralConfigSetup$DiffResult$.MODULE$.apply$default$2()));
    }

    private void createCentralConfigDir() {
        block0: {
            Path centralConfigDir = Paths.get(this.CENTRAL_CONFIG_PATH(), new String[0]);
            if (Files.exists(centralConfigDir, new LinkOption[0])) break block0;
            Files.createDirectories(centralConfigDir, new FileAttribute[0]);
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkMainRepositoryPropertiesNotExist$1(Path path) {
        return !path.endsWith(MODULE$.REPOSITORY_YAML_NAME()) || path.endsWith(MODULE$.REPOSITORY_YAML_NAME()) && !MODULE$.xlDeployConf().hasPath("xl.repository.database.db-url");
    }

    public static final /* synthetic */ boolean $anonfun$diffInitialFiles$2(Path x$2) {
        return !Files.exists(x$2, new LinkOption[0]);
    }

    private InitialCentralConfigSetup$() {
    }
}

