package ai.digital.deploy.cache.config

import io.github.resilience4j.circuitbreaker.CircuitBreaker
import org.springframework.stereotype.Component

import java.util.concurrent.atomic.AtomicReference

@Component
class CacheCircuitBreakerHolder(circuitBreaker: CircuitBreaker) {
  CacheCircuitBreakerHolder.cacheCircuitBreaker.set(circuitBreaker)
}

object CacheCircuitBreakerHolder {
  private val cacheCircuitBreaker = new AtomicReference[CircuitBreaker]

  def getCircuitBreaker: CircuitBreaker = CacheCircuitBreakerHolder.cacheCircuitBreaker.get()
}
