/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io;

import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.io.Inet;
import org.apache.pekko.io.Tcp;
import org.apache.pekko.io.Tcp$Abort$;
import org.apache.pekko.io.Tcp$Close$;
import org.apache.pekko.io.Tcp$ConfirmedClose$;
import org.apache.pekko.io.Tcp$NoAck$;
import org.apache.pekko.io.Tcp$ResumeReading$;
import org.apache.pekko.io.Tcp$ResumeWriting$;
import org.apache.pekko.io.Tcp$SuspendReading$;
import org.apache.pekko.io.Tcp$Unbind$;
import org.apache.pekko.io.Tcp$Write$;
import org.apache.pekko.japi.Util$;
import org.apache.pekko.util.ByteString;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;

public final class TcpMessage$ {
    public static final TcpMessage$ MODULE$ = new TcpMessage$();

    public Tcp.Command connect(InetSocketAddress remoteAddress, InetSocketAddress localAddress, java.lang.Iterable<Inet.SocketOption> options, FiniteDuration timeout, boolean pullMode) {
        return new Tcp.Connect(remoteAddress, (Option<InetSocketAddress>)Option$.MODULE$.apply((Object)localAddress), (Iterable<Inet.SocketOption>)Util$.MODULE$.immutableSeq(options), (Option<FiniteDuration>)Option$.MODULE$.apply((Object)timeout), pullMode);
    }

    public Tcp.Command connect(InetSocketAddress remoteAddress, InetSocketAddress localAddress, java.lang.Iterable<Inet.SocketOption> options, Duration timeout, boolean pullMode) {
        return this.connect(remoteAddress, localAddress, options, Duration$.MODULE$.fromNanos(timeout.toNanos()), pullMode);
    }

    public Tcp.Command connect(InetSocketAddress remoteAddress) {
        return new Tcp.Connect(remoteAddress, (Option<InetSocketAddress>)None$.MODULE$, (Iterable<Inet.SocketOption>)Nil$.MODULE$, (Option<FiniteDuration>)None$.MODULE$, false);
    }

    public Tcp.Command bind(ActorRef handler, InetSocketAddress endpoint, int backlog, java.lang.Iterable<Inet.SocketOption> options, boolean pullMode) {
        return new Tcp.Bind(handler, endpoint, backlog, (Iterable<Inet.SocketOption>)Util$.MODULE$.immutableSeq(options), pullMode);
    }

    public Tcp.Command bind(ActorRef handler, InetSocketAddress endpoint, int backlog) {
        return new Tcp.Bind(handler, endpoint, backlog, (Iterable<Inet.SocketOption>)Nil$.MODULE$, false);
    }

    public Tcp.Command register(ActorRef handler, boolean keepOpenOnPeerClosed, boolean useResumeWriting) {
        return new Tcp.Register(handler, keepOpenOnPeerClosed, useResumeWriting);
    }

    public Tcp.Command register(ActorRef handler) {
        return new Tcp.Register(handler, false, true);
    }

    public Tcp.Command unbind() {
        return Tcp$Unbind$.MODULE$;
    }

    public Tcp.Command close() {
        return Tcp$Close$.MODULE$;
    }

    public Tcp.Command confirmedClose() {
        return Tcp$ConfirmedClose$.MODULE$;
    }

    public Tcp.Command abort() {
        return Tcp$Abort$.MODULE$;
    }

    public Tcp.NoAck noAck(Object token) {
        return new Tcp.NoAck(token);
    }

    public Tcp.NoAck noAck() {
        return Tcp$NoAck$.MODULE$;
    }

    public Tcp.Command write(ByteString data, Tcp.Event ack) {
        return new Tcp.Write(data, ack);
    }

    public Tcp.Command write(ByteString data) {
        return Tcp$Write$.MODULE$.apply(data);
    }

    public Tcp.Command writeFile(String filePath, long position, long count, Tcp.Event ack) {
        return new Tcp.WritePath(Paths.get(filePath, new String[0]), position, count, ack);
    }

    public Tcp.Command writePath(Path filePath, long position, long count, Tcp.Event ack) {
        return new Tcp.WritePath(filePath, position, count, ack);
    }

    public Tcp.Command resumeWriting() {
        return Tcp$ResumeWriting$.MODULE$;
    }

    public Tcp.Command suspendReading() {
        return Tcp$SuspendReading$.MODULE$;
    }

    public Tcp.Command resumeReading() {
        return Tcp$ResumeReading$.MODULE$;
    }

    public Tcp.Command resumeAccepting(int batchSize) {
        return new Tcp.ResumeAccepting(batchSize);
    }

    private <T> Iterable<T> fromJava(java.lang.Iterable<T> coll) {
        return Util$.MODULE$.immutableSeq(coll);
    }

    private TcpMessage$() {
    }
}

