/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization;

import com.typesafe.config.Config;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.serialization.ByteBufferSerializer;
import org.apache.pekko.serialization.DisabledJavaSerializer;
import org.apache.pekko.serialization.JavaSerializer;
import org.apache.pekko.serialization.NullSerializer$;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializationSetup;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.SerializerDetails;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\u0011ew!\u00020`\u0011\u0003Ag!\u00026`\u0011\u0003Y\u0007\"\u0002:\u0002\t\u0003\u0019\bb\u0002;\u0002\u0005\u0004%i!\u001e\u0005\u0007s\u0006\u0001\u000bQ\u0002<\u0006\ti\f\u0001a\u001f\u0005\u000b\u0003c\t!\u0019!C\u0001C\u0006M\u0002\u0002\u0003B\u0001\u0003\u0001\u0006I!!\u000e\u0007\r\t=\u0011\u0001\u0001B\t\u0011)\u0011\u0019\u0002\u0003BC\u0002\u0013\u0005!Q\u0003\u0005\u000b\u0005SA!\u0011!Q\u0001\n\t]\u0001B\u0002:\t\t\u0003\u0011Y\u0003C\u0005\u00032!\u0011\r\u0011\"\u0001\u00034!A!q\b\u0005!\u0002\u0013\u0011)\u0004C\u0005\u0003B!\u0011\r\u0011\"\u0001\u00034!A!1\t\u0005!\u0002\u0013\u0011)\u0004C\u0004\u0003F!!iAa\u0012\t\u000f\t5\u0013\u0001\"\u0001\u0003P\u00191\u0011QI\u0001C\u0003\u000fB!\"!\u0019\u0013\u0005+\u0007I\u0011AA2\u0011)\t\tH\u0005B\tB\u0003%\u0011Q\r\u0005\u000b\u0003g\u0012\"Q3A\u0005\u0002\u0005U\u0004BCA?%\tE\t\u0015!\u0003\u0002x!1!O\u0005C\u0001\u0003\u007fB\u0011\"!\"\u0013\u0003\u0003%\t!a\"\t\u0013\u00055%#%A\u0005\u0002\u0005=\u0005\"CAS%E\u0005I\u0011AAT\u0011%\tYKEA\u0001\n\u0003\ni\u000bC\u0005\u0002@J\t\t\u0011\"\u0001\u0002B\"I\u0011\u0011\u001a\n\u0002\u0002\u0013\u0005\u00111\u001a\u0005\n\u0003#\u0014\u0012\u0011!C!\u0003'D\u0011\"!9\u0013\u0003\u0003%\t!a9\t\u0013\u00055(#!A\u0005B\u0005=\b\"CAz%\u0005\u0005I\u0011IA{\u0011%\t9PEA\u0001\n\u0003\nI\u0010C\u0005\u0002|J\t\t\u0011\"\u0011\u0002~\u001eI!1L\u0001\u0002\u0002#\u0005!Q\f\u0004\n\u0003\u000b\n\u0011\u0011!E\u0001\u0005?BaA]\u0013\u0005\u0002\t]\u0004\"CA|K\u0005\u0005IQIA}\u0011%\u0011I(JA\u0001\n\u0003\u0013Y\bC\u0005\u0003\u0002\u0016\n\t\u0011\"!\u0003\u0004\"I!\u0011S\u0013\u0002\u0002\u0013%!1\u0013\u0005\b\u00057\u000bA\u0011\u0001BO\u0011\u001d\u0011Y,\u0001C\u0001\u0005{3QA[0\u0001\u0005\u007fC!\"a\u001d.\u0005\u000b\u0007I\u0011\u0001Bd\u0011)\ti(\fB\u0001B\u0003%!Q\u0017\u0005\u0007e6\"\tA!3\t\u0013\t=WF1A\u0005\u0002\tE\u0007\u0002\u0003Bl[\u0001\u0006IAa5\t\u0013\teWF1A\u0005\u0002\tm\u0007\u0002\u0003Bo[\u0001\u0006I!!:\t\u0011\t}W\u0006)A\u0005\u0005CD\u0011B!<.\u0005\u0004%\tAa<\t\u0011\t]X\u0006)A\u0005\u0005cD\u0011B!?.\u0005\u0004%IAa?\t\u0011\r\u001dR\u0006)A\u0005\u0005{D\u0001b!\u000b.\t\u0003\t71\u0006\u0005\b\u00057kC\u0011BB\u0019\u0011\u001d\u0019i$\fC\u0001\u0007\u007fAqaa\u0016.\t\u0003\u0019I\u0006C\u0004\u0004X5\"\ta!)\t\u000f\r5V\u0006\"\u0003\u00040\"91\u0011X\u0017\u0005\u0002\rm\u0006bBB,[\u0011\u00051\u0011\u001d\u0005\b\u0007clC\u0011ABz\u0011\u001d\u001990\fC\u0001\u0007sDq\u0001\"\u0003.\t\u0003!Y\u0001C\u0004\u0005\n5\"I\u0001b\u0005\t\u0013\u0011mQF1A\u0005\n\u0011u\u0001\u0002\u0003C\u0016[\u0001\u0006I\u0001b\b\t\u0013\u00115RF1A\u0005\n\u0011=\u0002\u0002\u0003C\u001a[\u0001\u0006I\u0001\"\r\t\u0015\u0011URF1A\u0005\u0002\u0005$9\u0004\u0003\u0005\u0005>5\u0002\u000b\u0011\u0002C\u001d\u0011\u001d!y$\fC\u0005\t\u0003Bq\u0001\"\u0015.\t\u0013!\u0019\u0006C\u0004\u0005f5\"I\u0001b\u001a\t\u000f\u00115T\u0006\"\u0003\u0005p!9AqO\u0017\u0005\n\u0011e\u0004\"\u0003CC[\t\u0007I\u0011\u0002CD\u0011!!Y*\fQ\u0001\n\u0011%\u0005\"\u0003CO[\t\u0007I\u0011\u0001CP\u0011!!\u0019+\fQ\u0001\n\u0011\u0005\u0006\"\u0003CS[\t\u0007I\u0011\u0002CT\u0011!!Y+\fQ\u0001\n\u0011%\u0006b\u0002CW[\u0011%Aq\u0016\u0005\n\tkk#\u0019!C\u0005\u00057D\u0001\u0002b..A\u0003%\u0011Q\u001d\u0005\n\tsk#\u0019!C\u0005\u00057D\u0001\u0002b/.A\u0003%\u0011Q\u001d\u0005\b\t{kC\u0011\u0002C`\u0011!!\u0019-\fC\u0001C\u0012\u0015\u0017!D*fe&\fG.\u001b>bi&|gN\u0003\u0002aC\u0006i1/\u001a:jC2L'0\u0019;j_:T!AY2\u0002\u000bA,7n[8\u000b\u0005\u0011,\u0017AB1qC\u000eDWMC\u0001g\u0003\ry'oZ\u0002\u0001!\tI\u0017!D\u0001`\u00055\u0019VM]5bY&T\u0018\r^5p]N\u0011\u0011\u0001\u001c\t\u0003[Bl\u0011A\u001c\u0006\u0002_\u0006)1oY1mC&\u0011\u0011O\u001c\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005A\u0017A\u0005)fW.|\u0007+Y2lC\u001e,\u0007K]3gSb,\u0012A^\b\u0002o\u0006\n\u00010A\tpe\u001et\u0013\r]1dQ\u0016t\u0003/Z6l_:\n1\u0003U3lW>\u0004\u0016mY6bO\u0016\u0004&/\u001a4jq\u0002\u0012qb\u00117bgN\u001cVM]5bY&TXM\u001d\t\u0006[rt\u00181F\u0005\u0003{:\u0014a\u0001V;qY\u0016\u0014\u0004gA@\u0002\u001aA1\u0011\u0011AA\b\u0003+qA!a\u0001\u0002\fA\u0019\u0011Q\u00018\u000e\u0005\u0005\u001d!bAA\u0005O\u00061AH]8pizJ1!!\u0004o\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011CA\n\u0005\u0015\u0019E.Y:t\u0015\r\tiA\u001c\t\u0005\u0003/\tI\u0002\u0004\u0001\u0005\u0017\u0005mQ!!A\u0001\u0002\u000b\u0005\u0011Q\u0004\u0002\u0004?\u0012\n\u0014\u0003BA\u0010\u0003K\u00012!\\A\u0011\u0013\r\t\u0019C\u001c\u0002\b\u001d>$\b.\u001b8h!\ri\u0017qE\u0005\u0004\u0003Sq'aA!osB\u0019\u0011.!\f\n\u0007\u0005=rL\u0001\u0006TKJL\u0017\r\\5{KJ\f1dY;se\u0016tG\u000f\u0016:b]N\u0004xN\u001d;J]\u001a|'/\\1uS>tWCAA\u001b!\u0019\t9$!\u0010\u0002B5\u0011\u0011\u0011\b\u0006\u0004\u0003wq\u0017\u0001B;uS2LA!a\u0010\u0002:\tyA)\u001f8b[&\u001cg+\u0019:jC\ndW\rE\u0002\u0002DIi\u0011!\u0001\u0002\f\u0013:4wN]7bi&|gn\u0005\u0004\u0013Y\u0006%\u0013q\n\t\u0004[\u0006-\u0013bAA']\n9\u0001K]8ek\u000e$\b\u0003BA)\u00037rA!a\u0015\u0002X9!\u0011QAA+\u0013\u0005y\u0017bAA-]\u00069\u0001/Y2lC\u001e,\u0017\u0002BA/\u0003?\u0012AbU3sS\u0006d\u0017N_1cY\u0016T1!!\u0017o\u0003\u001d\tG\r\u001a:fgN,\"!!\u001a\u0011\t\u0005\u001d\u0014QN\u0007\u0003\u0003SR1!a\u001bb\u0003\u0015\t7\r^8s\u0013\u0011\ty'!\u001b\u0003\u000f\u0005#GM]3tg\u0006A\u0011\r\u001a3sKN\u001c\b%\u0001\u0004tsN$X-\\\u000b\u0003\u0003o\u0002B!a\u001a\u0002z%!\u00111PA5\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u000fML8\u000f^3nAQ1\u0011\u0011IAA\u0003\u0007Cq!!\u0019\u0018\u0001\u0004\t)\u0007C\u0004\u0002t]\u0001\r!a\u001e\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003\u0003\nI)a#\t\u0013\u0005\u0005\u0004\u0004%AA\u0002\u0005\u0015\u0004\"CA:1A\u0005\t\u0019AA<\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!%+\t\u0005\u0015\u00141S\u0016\u0003\u0003+\u0003B!a&\u0002\"6\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000bi*A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u00148\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002$\u0006e%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAUU\u0011\t9(a%\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u000b\u0005\u0003\u00022\u0006mVBAAZ\u0015\u0011\t),a.\u0002\t1\fgn\u001a\u0006\u0003\u0003s\u000bAA[1wC&!\u0011QXAZ\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u0019\t\u0004[\u0006\u0015\u0017bAAd]\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QEAg\u0011%\ty-HA\u0001\u0002\u0004\t\u0019-A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003+\u0004b!a6\u0002^\u0006\u0015RBAAm\u0015\r\tYN\\\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAp\u00033\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011Q]Av!\ri\u0017q]\u0005\u0004\u0003St'a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u001f|\u0012\u0011!a\u0001\u0003K\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011qVAy\u0011%\ty\rIA\u0001\u0002\u0004\t\u0019-\u0001\u0005iCND7i\u001c3f)\t\t\u0019-\u0001\u0005u_N#(/\u001b8h)\t\ty+\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003K\fy\u0010C\u0005\u0002P\u000e\n\t\u00111\u0001\u0002&\u0005a2-\u001e:sK:$HK]1ogB|'\u000f^%oM>\u0014X.\u0019;j_:\u0004\u0003fA\u0004\u0003\u0006A!!q\u0001B\u0006\u001b\t\u0011IAC\u0002\u0002 \u0006LAA!\u0004\u0003\n\tY\u0011J\u001c;fe:\fG.\u00119j\u0005!\u0019V\r\u001e;j]\u001e\u001c8C\u0001\u0005m\u0003\u0019\u0019wN\u001c4jOV\u0011!q\u0003\t\u0005\u00053\u0011)#\u0004\u0002\u0003\u001c)!!1\u0003B\u000f\u0015\u0011\u0011yB!\t\u0002\u0011QL\b/Z:bM\u0016T!Aa\t\u0002\u0007\r|W.\u0003\u0003\u0003(\tm!AB\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0015\t\t5\"q\u0006\t\u0004\u0003\u0007B\u0001b\u0002B\n\u0017\u0001\u0007!qC\u0001\f'\u0016\u0014\u0018.\u00197ju\u0016\u00148/\u0006\u0002\u00036AA\u0011\u0011\u0001B\u001c\u0005w\u0011Y$\u0003\u0003\u0003:\u0005M!aA'baB!\u0011\u0011\u0001B\u001f\u0013\u0011\ti,a\u0005\u0002\u0019M+'/[1mSj,'o\u001d\u0011\u0002+M+'/[1mSj\fG/[8o\u0005&tG-\u001b8hg\u000612+\u001a:jC2L'0\u0019;j_:\u0014\u0015N\u001c3j]\u001e\u001c\b%A\u0006d_:4\u0017n\u001a+p\u001b\u0006\u0004H\u0003\u0002B\u001b\u0005\u0013BqAa\u0013\u0011\u0001\u0004\u00119\"A\u0002dM\u001e\f1c]3sS\u0006d\u0017N_3e\u0003\u000e$xN\u001d)bi\"$BAa\u000f\u0003R!9!1K\tA\u0002\tU\u0013\u0001C1di>\u0014(+\u001a4\u0011\t\u0005\u001d$qK\u0005\u0005\u00053\nIG\u0001\u0005BGR|'OU3g\u0003-IeNZ8s[\u0006$\u0018n\u001c8\u0011\u0007\u0005\rSeE\u0003&\u0005C\u0012i\u0007\u0005\u0006\u0003d\t%\u0014QMA<\u0003\u0003j!A!\u001a\u000b\u0007\t\u001dd.A\u0004sk:$\u0018.\\3\n\t\t-$Q\r\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003\u0002B8\u0005kj!A!\u001d\u000b\t\tM\u0014qW\u0001\u0003S>LA!!\u0018\u0003rQ\u0011!QL\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003\u0003\u0012iHa \t\u000f\u0005\u0005\u0004\u00061\u0001\u0002f!9\u00111\u000f\u0015A\u0002\u0005]\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u000b\u0013i\tE\u0003n\u0005\u000f\u0013Y)C\u0002\u0003\n:\u0014aa\u00149uS>t\u0007CB7}\u0003K\n9\bC\u0005\u0003\u0010&\n\t\u00111\u0001\u0002B\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tU\u0005\u0003BAY\u0005/KAA!'\u00024\n1qJ\u00196fGR\f\u0001d^5uQR\u0013\u0018M\\:q_J$\u0018J\u001c4pe6\fG/[8o+\u0011\u0011yJ!*\u0015\t\t\u0005&1\u0017\u000b\u0005\u0005G\u0013I\u000b\u0005\u0003\u0002\u0018\t\u0015Fa\u0002BTW\t\u0007\u0011Q\u0004\u0002\u0002)\"9!1V\u0016A\u0002\t5\u0016!\u00014\u0011\u000b5\u0014yKa)\n\u0007\tEfNA\u0005Gk:\u001cG/[8oa!9\u00111O\u0016A\u0002\tU\u0006\u0003BA4\u0005oKAA!/\u0002j\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\u0006qr-\u001a;DkJ\u0014XM\u001c;Ue\u0006t7\u000f]8si&sgm\u001c:nCRLwN\u001c\u000b\u0003\u0003\u0003\u001aB!\f7\u0003BB!\u0011q\rBb\u0013\u0011\u0011)-!\u001b\u0003\u0013\u0015CH/\u001a8tS>tWC\u0001B[)\u0011\u0011YM!4\u0011\u0005%l\u0003bBA:a\u0001\u0007!QW\u0001\tg\u0016$H/\u001b8hgV\u0011!1\u001b\t\u0004\u0005+DaBA5\u0001\u0003%\u0019X\r\u001e;j]\u001e\u001c\b%\u0001\fBY2|wOS1wCN+'/[1mSj\fG/[8o+\t\t)/A\fBY2|wOS1wCN+'/[1mSj\fG/[8oA\u0005!q\f\\8h!\u0011\u0011\u0019O!;\u000e\u0005\t\u0015(b\u0001BtC\u0006)QM^3oi&!!1\u001eBs\u0005Qi\u0015M]6fe2{wmZ5oO\u0006#\u0017\r\u001d;fe\u0006\u0019An\\4\u0016\u0005\tE\b\u0003\u0002Br\u0005gLAA!>\u0003f\nqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002\nQ\"\\1oS\u001a,7\u000f^\"bG\",WC\u0001B\u007f!\u0019\u0011ypa\u0003\u0004\u00105\u00111\u0011\u0001\u0006\u0005\u0007\u0007\u0019)!\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0007\u000f\u0019I!\u0001\u0006d_:\u001cWO\u001d:f]RTA!a\u000f\u00028&!1QBB\u0001\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007\u0003CB\t\u0007/\u0011Yd!\u0007\u000e\u0005\rM!\u0002BB\u000b\u00033\f\u0011\"[7nkR\f'\r\\3\n\t\te21\u0003\t\u0006[\n\u001d51\u0004\u0019\u0005\u0007;\u0019\u0019\u0003\u0005\u0004\u00022\u000e}1\u0011E\u0005\u0005\u0003#\t\u0019\f\u0005\u0003\u0002\u0018\r\rBaCB\u0013s\u0005\u0005\t\u0011!B\u0001\u0003;\u00111a\u0018\u00133\u00039i\u0017M\\5gKN$8)Y2iK\u0002\n\u0001d]3sS\u0006d\u0017N_1uS>t\u0017J\u001c4pe6\fG/[8o+\t\u0019i\u0003E\u0002\u0003VJA3A\u000fB\u0003+\u0011\u0019\u0019da\u000e\u0015\t\rU2\u0011\b\t\u0005\u0003/\u00199\u0004B\u0004\u0003(n\u0012\r!!\b\t\u000f\t-6\b1\u0001\u0004<A)QNa,\u00046\u0005I1/\u001a:jC2L'0\u001a\u000b\u0005\u0007\u0003\u001a\u0019\u0006\u0005\u0004\u00028\r\r3qI\u0005\u0005\u0007\u000b\nIDA\u0002Uef\u0004R!\\B%\u0007\u001bJ1aa\u0013o\u0005\u0015\t%O]1z!\ri7qJ\u0005\u0004\u0007#r'\u0001\u0002\"zi\u0016Daa!\u0016=\u0001\u0004a\u0017!A8\u0002\u0017\u0011,7/\u001a:jC2L'0Z\u000b\u0005\u00077\u001a\t\u0007\u0006\u0005\u0004^\r\r4qMB6!\u0019\t9da\u0011\u0004`A!\u0011qCB1\t\u001d\u00119+\u0010b\u0001\u0003;Aqa!\u001a>\u0001\u0004\u00199%A\u0003csR,7\u000fC\u0004\u0004ju\u0002\r!a1\u0002\u0019M,'/[1mSj,'/\u00133\t\u000f\r5T\b1\u0001\u0004p\u0005)1\r\\1{uB)QNa\"\u0004rA\"11OB<!\u0019\t\t!a\u0004\u0004vA!\u0011qCB<\t1\u0019Iha\u001f\u0002\u0002\u0003\u0005)\u0011ABF\u0005\ryF\u0005\u000e\u0005\b\u0007[j\u0004\u0019AB?!\u0015i'qQB@a\u0011\u0019\ti!\"\u0011\r\u0005\u0005\u0011qBBB!\u0011\t9b!\"\u0005\u0019\re41PA\u0001\u0002\u0003\u0015\taa\"\u0012\t\u0005}1\u0011\u0012\t\u0005\u0003/\u0019\t'\u0005\u0003\u0002 \r}\u0003fC\u001f\u0004\u0010\u000eU5qSBN\u0007;\u00032!\\BI\u0013\r\u0019\u0019J\u001c\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017aB7fgN\fw-Z\u0011\u0003\u00073\u000bA(V:fA\u0011,7/\u001a:jC2L'0\u001a\u0011uQ\u0006$\b%Y2dKB$8\u000f\t;iK\u0002\u0002W.\u00198jM\u0016\u001cH\u000f\u0019\u0011bg\u0002\n\u0007e\u00197bgN\u0004c.Y7f]\u0005)1/\u001b8dK\u0006\u00121qT\u0001\u000b\u0003.\\\u0017\r\t\u001a/m9\u0002D\u0003CBR\u0007K\u001b9k!+\u0011\u000b\u0005]21\t7\t\u000f\r\u0015d\b1\u0001\u0004H!91\u0011\u000e A\u0002\u0005\r\u0007bBBV}\u0001\u0007!1H\u0001\t[\u0006t\u0017NZ3ti\u0006!B-Z:fe&\fG.\u001b>f\u0005f$X-\u0011:sCf$r\u0001\\BY\u0007g\u001b9\fC\u0004\u0004f}\u0002\raa\u0012\t\u000f\rUv\b1\u0001\u0002,\u0005Q1/\u001a:jC2L'0\u001a:\t\u000f\r-v\b1\u0001\u0003<\u0005)B-Z:fe&\fG.\u001b>f\u0005f$XMQ;gM\u0016\u0014Hc\u00027\u0004>\u000e57q\u001a\u0005\b\u0007\u007f\u0003\u0005\u0019ABa\u0003\r\u0011WO\u001a\t\u0005\u0007\u0007\u001cI-\u0004\u0002\u0004F*!1qYA\\\u0003\rq\u0017n\\\u0005\u0005\u0007\u0017\u001c)M\u0001\u0006CsR,')\u001e4gKJDqa!\u001bA\u0001\u0004\t\u0019\rC\u0004\u0004,\u0002\u0003\rAa\u000f)\u000b\u0001\u001b\u0019na8\u0011\u000b5\u001c)n!7\n\u0007\r]gN\u0001\u0004uQJ|wo\u001d\t\u0005\u0005_\u001aY.\u0003\u0003\u0004^\nE$\u0001\u0007(piN+'/[1mSj\f'\r\\3Fq\u000e,\u0007\u000f^5p]\u000e\u00121\u0011\\\u000b\u0005\u0007G\u001cI\u000f\u0006\u0004\u0004f\u000e-8Q\u001e\t\u0007\u0003o\u0019\u0019ea:\u0011\t\u0005]1\u0011\u001e\u0003\b\u0005O\u000b%\u0019AA\u000f\u0011\u001d\u0019)'\u0011a\u0001\u0007\u000fBqa!\u001cB\u0001\u0004\u0019y\u000f\u0005\u0004\u0002\u0002\u0005=1q]\u0001\u0012M&tGmU3sS\u0006d\u0017N_3s\r>\u0014H\u0003BA\u0016\u0007kDaa!\u0016C\u0001\u0004a\u0017!D:fe&\fG.\u001b>fe\u001a{'\u000f\u0006\u0003\u0002,\rm\bbBB7\u0007\u0002\u00071Q \u0019\u0005\u0007\u007f$\u0019\u0001\u0005\u0004\u0002\u0002\u0005=A\u0011\u0001\t\u0005\u0003/!\u0019\u0001\u0002\u0007\u0005\u0006\rm\u0018\u0011!A\u0001\u0006\u0003\tiBA\u0002`IaBSaQBj\u0007?\fAb]3sS\u0006d\u0017N_3s\u001f\u001a$B\u0001\"\u0004\u0005\u0010A1\u0011qGB\"\u0003WAq\u0001\"\u0005E\u0001\u0004\u0011Y$A\u0007tKJL\u0017\r\\5{KJ4\u0015K\u0014\u000b\u0007\t\u001b!)\u0002\"\u0007\t\u000f\u0011]Q\t1\u0001\u0003<\u0005Y!-\u001b8eS:<g*Y7f\u0011\u001d!\t\"\u0012a\u0001\u0005w\t\u0011c]3sS\u0006d\u0017N_3s\t\u0016$\u0018-\u001b7t+\t!y\u0002\u0005\u0004\u0004\u0012\u0011\u0005BQE\u0005\u0005\tG\u0019\u0019BA\u0002TKF\u00042!\u001bC\u0014\u0013\r!Ic\u0018\u0002\u0012'\u0016\u0014\u0018.\u00197ju\u0016\u0014H)\u001a;bS2\u001c\u0018AE:fe&\fG.\u001b>fe\u0012+G/Y5mg\u0002\n1b]3sS\u0006d\u0017N_3sgV\u0011A\u0011\u0007\t\t\u0003\u0003\u00119Da\u000f\u0002,\u0005a1/\u001a:jC2L'0\u001a:tA\u0005A!-\u001b8eS:<7/\u0006\u0002\u0005:A11\u0011\u0003C\u0011\tw\u00012A!6\u0006\u0003%\u0011\u0017N\u001c3j]\u001e\u001c\b%\u0001\u000ff]N,(/Z(oYf\fE\u000e\\8xK\u0012\u001cVM]5bY&TXM]:\u0015\t\u0011\rC\u0011\n\t\u0004[\u0012\u0015\u0013b\u0001C$]\n!QK\\5u\u0011\u001d!Y\u0005\u0014a\u0001\t\u001b\nA!\u001b;feB1\u0011\u0011\u000bC(\u0003WIA!a8\u0002`\u0005\u0001s/\u0019:o+:,\u0007\u0010]3di\u0016$gj\u001c8QK.\\wnU3sS\u0006d\u0017N_3s)\u0019\t)\u000f\"\u0016\u0005b!91QN'A\u0002\u0011]\u0003\u0007\u0002C-\t;\u0002b!!\u0001\u0002\u0010\u0011m\u0003\u0003BA\f\t;\"A\u0002b\u0018\u0005V\u0005\u0005\t\u0011!B\u0001\u0003;\u0011Aa\u0018\u00132a!9A1M'A\u0002\u0005-\u0012aA:fe\u0006\u00192\r[3dW\u001e{wn\u001a7f!J|Go\u001c2vMR!\u0011Q\u001dC5\u0011\u001d!YG\u0014a\u0001\u0005w\t\u0011b\u00197bgNt\u0015-\\3\u0002\u0015\rDWmY6DY\u0006\u001c8\u000f\u0006\u0004\u0002f\u0012EDQ\u000f\u0005\b\tgz\u0005\u0019\u0001B\u001e\u0003\u0019\u0001(/\u001a4jq\"9A1N(A\u0002\tm\u0012\u0001B:peR$B\u0001\"\u000f\u0005|!9AQ\u0010)A\u0002\u0011}\u0014AA5o!\u0019\t\t\u0006\"!\u0005<%!A1QA0\u0005!IE/\u001a:bE2,\u0017!D:fe&\fG.\u001b>fe6\u000b\u0007/\u0006\u0002\u0005\nBAA1\u0012CG\t#\u000bY#\u0004\u0002\u0004\u0006%!AqRB\u0003\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\u0019\u0005\t'#9\n\u0005\u0004\u0002\u0002\u0005=AQ\u0013\t\u0005\u0003/!9\nB\u0006\u0005\u001aJ\u000b\t\u0011!A\u0003\u0002\u0005u!\u0001B0%cE\nab]3sS\u0006d\u0017N_3s\u001b\u0006\u0004\b%\u0001\u000btKJL\u0017\r\\5{KJ\u0014\u00150\u00133f]RLG/_\u000b\u0003\tC\u0003\u0002\"!\u0001\u00038\u0005\r\u00171F\u0001\u0016g\u0016\u0014\u0018.\u00197ju\u0016\u0014()_%eK:$\u0018\u000e^=!\u0003e\tX/[2l'\u0016\u0014\u0018.\u00197ju\u0016\u0014()_%eK:$\u0018\u000e^=\u0016\u0005\u0011%\u0006#B7\u0004J\u0005-\u0012AG9vS\u000e\\7+\u001a:jC2L'0\u001a:Cs&#WM\u001c;jif\u0004\u0013!E4fiN+'/[1mSj,'OQ=JIR!\u00111\u0006CY\u0011\u001d!\u0019l\u0016a\u0001\u0003\u0007\f!!\u001b3\u0002C%\u001c(*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8XCJt\u0017N\\4F]\u0006\u0014G.\u001a3\u0002E%\u001c(*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8XCJt\u0017N\\4F]\u0006\u0014G.\u001a3!\u0003\u0001J7oV1s]&twm\u00148O_Z+'/\u001b4jG\u0006$\u0018n\u001c8F]\u0006\u0014G.\u001a3\u0002C%\u001cx+\u0019:oS:<wJ\u001c(p-\u0016\u0014\u0018NZ5dCRLwN\\#oC\ndW\r\u001a\u0011\u00025%\u001cH)[:bY2|w/\u001a3KCZ\f7+\u001a:jC2L'0\u001a:\u0015\t\u0005\u0015H\u0011\u0019\u0005\b\u0007kc\u0006\u0019AA\u0016\u0003u\u0019\bn\\;mI^\u000b'O\\!c_V$(*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0016\u0014HCBAs\t\u000f$)\u000eC\u0004\u0005Jv\u0003\r\u0001b3\u0002\u001fM,'/[1mSj,Gm\u00117bgN\u0004D\u0001\"4\u0005RB1\u0011\u0011AA\b\t\u001f\u0004B!a\u0006\u0005R\u0012aA1\u001bCd\u0003\u0003\u0005\tQ!\u0001\u0002\u001e\t!q\fJ\u00194\u0011\u001d\u0019),\u0018a\u0001\u0003WA3!\u0018B\u0003\u0001")
public class Serialization
implements Extension {
    private final ExtendedActorSystem system;
    private final Settings settings;
    private final boolean AllowJavaSerialization;
    private final MarkerLoggingAdapter _log;
    private final LoggingAdapter log;
    private final AtomicReference<scala.collection.immutable.Map<String, Option<Class<?>>>> manifestCache;
    private final Seq<SerializerDetails> serializerDetails;
    private final scala.collection.immutable.Map<String, Serializer> serializers;
    private final Seq<Tuple2<Class<?>, Serializer>> bindings;
    private final ConcurrentHashMap<Class<?>, Serializer> serializerMap;
    private final scala.collection.immutable.Map<Object, Serializer> serializerByIdentity;
    private final Serializer[] quickSerializerByIdentity;
    private final boolean isJavaSerializationWarningEnabled;
    private final boolean isWarningOnNoVerificationEnabled;

    public static Information getCurrentTransportInformation() {
        return Serialization$.MODULE$.getCurrentTransportInformation();
    }

    public static String serializedActorPath(ActorRef actorRef) {
        return Serialization$.MODULE$.serializedActorPath(actorRef);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Settings settings() {
        return this.settings;
    }

    public boolean AllowJavaSerialization() {
        return this.AllowJavaSerialization;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    private AtomicReference<scala.collection.immutable.Map<String, Option<Class<?>>>> manifestCache() {
        return this.manifestCache;
    }

    @InternalApi
    public Information serializationInformation() {
        return this.system().provider().serializationInformation();
    }

    private <T> T withTransportInformation(Function0<T> f) {
        Object object;
        Information oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            object = f.apply();
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return (T)object;
    }

    public Try<byte[]> serialize(Object o) {
        Try try_;
        Information withTransportInformation_oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (withTransportInformation_oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.findSerializerFor(o$1).toBinary(o$1));
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)withTransportInformation_oldInfo);
        }
        return try_;
    }

    public <T> Try<T> deserialize(byte[] bytes, int serializerId, Option<Class<? extends T>> clazz) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Object object;
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(155).append("Cannot find serializer with id [").append(serializerId).append("]").append(clazz.map((Function1 & Serializable)c -> new StringBuilder(11).append(" (class [").append(c.getName()).append("])").toString()).getOrElse((Function0 & Serializable)() -> "")).append(". ").append("The most probable reason is that the configuration entry ").append("pekko.actor.serializers is not in sync between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            Information withTransportInformation_oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
            try {
                if (withTransportInformation_oldInfo == null) {
                    Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
                }
                object = serializer2.fromBinary(bytes, clazz);
            }
            finally {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)withTransportInformation_oldInfo);
            }
            return object;
        });
    }

    public Try<Object> deserialize(byte[] bytes, int serializerId, String manifest) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(169).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").append("pekko.actor.serializers is not in sync between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return this.deserializeByteArray(bytes, serializer2, manifest);
        });
    }

    private Object deserializeByteArray(byte[] bytes, Serializer serializer, String manifest) {
        Object object;
        Information withTransportInformation_oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (withTransportInformation_oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            object = Serialization.$anonfun$deserializeByteArray$1(this, serializer, bytes, manifest);
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)withTransportInformation_oldInfo);
        }
        return object;
    }

    public Object deserializeByteBuffer(ByteBuffer buf, int serializerId, String manifest) throws NotSerializableException {
        Object object;
        Serializer serializer;
        try {
            serializer = this.getSerializerById(serializerId);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringBuilder(170).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").append("pekko.actor.serializers is not in synch between the two systems.").toString());
        }
        Serializer serializer2 = serializer;
        Information oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            if (serializer2 instanceof ByteBufferSerializer) {
                object = ((ByteBufferSerializer)((Object)serializer2)).fromBinary(buf, manifest);
            } else {
                byte[] bytes = new byte[buf.remaining()];
                buf.get(bytes);
                object = this.deserializeByteArray(bytes, serializer2, manifest);
            }
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return object;
    }

    public <T> Try<T> deserialize(byte[] bytes, Class<T> clazz) {
        Try try_;
        Information withTransportInformation_oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (withTransportInformation_oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.serializerFor(clazz$2).fromBinary(bytes$4, (Option<Class<?>>)new Some((Object)clazz$2)));
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)withTransportInformation_oldInfo);
        }
        return try_;
    }

    public Serializer findSerializerFor(Object o) {
        if (o == null) {
            return NullSerializer$.MODULE$;
        }
        return this.serializerFor(o.getClass());
    }

    public Serializer serializerFor(Class<?> clazz) throws NotSerializableException {
        Serializer serializer = this.serializerMap().get(clazz);
        if (serializer == null) {
            Serializer serializer2;
            SeqOps seqOps;
            Seq seq = (Seq)this.bindings().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$3(clazz, x0$1)));
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = Seq$.MODULE$.unapplySeq((SeqOps)seq))) {
                new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0) {
                    throw new NotSerializableException(new StringBuilder(49).append("No configured serialization-bindings for class [").append(clazz.getName()).append("]").toString());
                }
            }
            if (Serialization.unique$1(seq)) {
                serializer2 = (Serializer)((Tuple2)seq.head())._2();
            } else {
                Seq possibilitiesWithoutJavaSerializer = (Seq)seq.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$4(x0$2)));
                if (possibilitiesWithoutJavaSerializer.isEmpty()) {
                    throw new NotSerializableException(new StringBuilder(52).append("More than one JavaSerializer configured for class [").append(clazz.getName()).append("]").toString());
                }
                if (!Serialization.unique$1(possibilitiesWithoutJavaSerializer)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Multiple serializers found for [{}], choosing first of: [{}]", (Object)clazz.getName(), (Object)((IterableOnceOps)possibilitiesWithoutJavaSerializer.map((Function1 & Serializable)x0$3 -> {
                        if (x0$3 != null) {
                            return ((Serializer)x0$3._2()).getClass().getName();
                        }
                        throw new MatchError(null);
                    })).mkString(", "));
                }
                serializer2 = (Serializer)((Tuple2)possibilitiesWithoutJavaSerializer.head())._2();
            }
            Serializer ser = serializer2;
            Serializer serializer3 = this.serializerMap().putIfAbsent(clazz, ser);
            if (serializer3 == null) {
                if (this.shouldWarnAboutJavaSerializer(clazz, ser)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Using the Java serializer for class [{}] which is not recommended because of performance implications. Use another serializer or disable this warning using the setting 'pekko.actor.warn-about-java-serializer-usage'", (Object)clazz.getName());
                }
                if (!this.warnUnexpectedNonPekkoSerializer(clazz, ser)) {
                    this.log().debug("Using serializer [{}] for message [{}]", ser.getClass().getName(), clazz.getName());
                }
                return ser;
            }
            return serializer3;
        }
        return serializer;
    }

    public Try<Serializer> serializerOf(String serializerFQN) {
        return this.serializerOf("", serializerFQN);
    }

    /*
     * Unable to fully structure code
     */
    private Try<Serializer> serializerOf(String bindingName, String serializerFQN) {
        if (this.system().settings().AllowJavaSerialization()) ** GOTO lbl-1000
        v0 = serializerFQN;
        var4_3 = JavaSerializer.class.getName();
        if (!(v0 != null ? v0.equals(var4_3) == false : var4_3 != null)) {
            this.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `pekko.actor.allow-java-serialization = off`.");
            v1 = DisabledJavaSerializer.class.getName();
        } else lbl-1000:
        // 2 sources

        {
            v1 = serializerFQN;
        }
        fqn = v1;
        return this.system().dynamicAccess().createInstanceFor(fqn, (Seq<Tuple2<Class<?>, Object>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), (Object)this.system()), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new Serializable(this, fqn, bindingName){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            public final String fqn$1;
            public final String bindingName$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof NoSuchMethodException) {
                    return (B1)this.$outer.system().dynamicAccess().createInstanceFor(this.fqn$1, (Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$, ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new Serializable(this){
                        private static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$serializerOf$1 $outer;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            if (x1 instanceof NoSuchMethodException) {
                                NoSuchMethodException noSuchMethodException = (NoSuchMethodException)x1;
                                String string = this.$outer.bindingName$1;
                                String string2 = "";
                                if (string != null && string.equals(string2)) {
                                    throw noSuchMethodException;
                                }
                                return (B1)this.$outer.org$apache$pekko$serialization$Serialization$$anonfun$$$outer().system().dynamicAccess().createInstanceFor(this.$outer.fqn$1, (Seq<Tuple2<Class<?>, Object>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), (Object)this.$outer.org$apache$pekko$serialization$Serialization$$anonfun$$$outer().system()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(String.class), (Object)this.$outer.bindingName$1), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(Serializer.class));
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            return x1 instanceof NoSuchMethodException;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                return x1 instanceof NoSuchMethodException;
            }

            public /* synthetic */ Serialization org$apache$pekko$serialization$Serialization$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fqn$1 = fqn$1;
                this.bindingName$1 = bindingName$1;
            }
        });
    }

    private Seq<SerializerDetails> serializerDetails() {
        return this.serializerDetails;
    }

    private scala.collection.immutable.Map<String, Serializer> serializers() {
        return this.serializers;
    }

    public Seq<Tuple2<Class<?>, Serializer>> bindings() {
        return this.bindings;
    }

    private void ensureOnlyAllowedSerializers(Iterator<Serializer> iter) {
        if (!this.system().settings().AllowJavaSerialization()) {
            Predef$.MODULE$.require(iter.forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$ensureOnlyAllowedSerializers$1(this, x$6))), (Function0 & Serializable)() -> "Disallowed JavaSerializer binding.");
            return;
        }
    }

    private boolean warnUnexpectedNonPekkoSerializer(Class<?> clazz, Serializer ser) {
        String clazzName = clazz.getName();
        if (clazzName.startsWith("org.apache.pekko.") && !ser.getClass().getName().startsWith("org.apache.pekko.")) {
            this.log().warning("Using serializer [{}] for message [{}]. Note that this serializer is not implemented by Apache Pekko. It's not recommended to replace serializers for messages provided by Apache Pekko.", (Object)ser.getClass().getName(), (Object)clazzName);
            return true;
        }
        return false;
    }

    private boolean checkGoogleProtobuf(String className) {
        return this.checkClass("com.google.protobuf", className);
    }

    private boolean checkClass(String prefix, String className) {
        return !className.startsWith(prefix) || this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).isSuccess();
    }

    private Seq<Tuple2<Class<?>, Serializer>> sort(Iterable<Tuple2<Class<?>, Serializer>> in) {
        return (Seq)((IterableOnceOps)in.foldLeft((Object)new ArrayBuffer(in.size()), (Function2 & Serializable)(buf, ca) -> {
            int n = buf.indexWhere((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$sort$2(ca, x$7)));
            switch (n) {
                case -1: {
                    buf.append(ca);
                    break;
                }
                default: {
                    buf.insert(n, ca);
                }
            }
            return buf;
        })).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$));
    }

    private ConcurrentHashMap<Class<?>, Serializer> serializerMap() {
        return this.serializerMap;
    }

    public scala.collection.immutable.Map<Object, Serializer> serializerByIdentity() {
        return this.serializerByIdentity;
    }

    private Serializer[] quickSerializerByIdentity() {
        return this.quickSerializerByIdentity;
    }

    private Serializer getSerializerById(int id) {
        if (0 <= id && id < this.quickSerializerByIdentity().length) {
            Serializer serializer = this.quickSerializerByIdentity()[id];
            if (serializer == null) {
                throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(id).toString());
            }
            return serializer;
        }
        return (Serializer)this.serializerByIdentity().apply((Object)BoxesRunTime.boxToInteger((int)id));
    }

    private boolean isJavaSerializationWarningEnabled() {
        return this.isJavaSerializationWarningEnabled;
    }

    private boolean isWarningOnNoVerificationEnabled() {
        return this.isWarningOnNoVerificationEnabled;
    }

    public boolean org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer(Serializer serializer) {
        return serializer instanceof JavaSerializer && !this.system().settings().AllowJavaSerialization();
    }

    @InternalApi
    public boolean shouldWarnAboutJavaSerializer(Class<?> serializedClass, Serializer serializer) {
        return this.isJavaSerializationWarningEnabled() && (serializer instanceof JavaSerializer || serializer instanceof DisabledJavaSerializer) && !serializedClass.getName().startsWith("org.apache.pekko.") && !serializedClass.getName().startsWith("java.lang.") && !this.suppressWarningOnNonSerializationVerification$1(serializedClass);
    }

    public static final /* synthetic */ Object $anonfun$deserialize$4(Serializer serializer$1, byte[] bytes$1, Option clazz$1) {
        return serializer$1.fromBinary(bytes$1, clazz$1);
    }

    private final boolean updateCache$1(scala.collection.immutable.Map cache, String key, Option value) {
        while (!this.manifestCache().compareAndSet(cache, (scala.collection.immutable.Map<String, Option<Class<?>>>)cache.updated((Object)key, (Object)value))) {
            cache = this.manifestCache().get();
        }
        return true;
    }

    public static final /* synthetic */ Object $anonfun$deserializeByteArray$1(Serialization $this, Serializer serializer$2, byte[] bytes$3, String manifest$2) {
        if (serializer$2 instanceof SerializerWithStringManifest) {
            return ((SerializerWithStringManifest)serializer$2).fromBinary(bytes$3, manifest$2);
        }
        String string = manifest$2;
        String string2 = "";
        if (string != null && string.equals(string2)) {
            return serializer$2.fromBinary(bytes$3, (Option<Class<?>>)None$.MODULE$);
        }
        scala.collection.immutable.Map<String, Option<Class<?>>> cache = $this.manifestCache().get();
        Option option = cache.get((Object)manifest$2);
        if (option instanceof Some) {
            Option cachedClassManifest = (Option)((Some)option).value();
            return serializer$2.fromBinary(bytes$3, cachedClassManifest);
        }
        if (None$.MODULE$.equals(option)) {
            Try try_ = $this.system().dynamicAccess().getClassFor(manifest$2, ClassTag$.MODULE$.AnyRef());
            if (try_ instanceof Success) {
                Class classManifest = (Class)((Success)try_).value();
                Some classManifestOption = new Some((Object)classManifest);
                $this.updateCache$1(cache, manifest$2, (Option)classManifestOption);
                return serializer$2.fromBinary(bytes$3, (Option<Class<?>>)classManifestOption);
            }
            if (try_ instanceof Failure) {
                throw new NotSerializableException(new StringBuilder(56).append("Cannot find manifest class [").append(manifest$2).append("] for serializer with id [").append(serializer$2.identifier()).append("].").toString());
            }
            throw new MatchError(try_);
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$1(Tuple2 possibility$1, Tuple2 x$1) {
        return ((Class)x$1._1()).isAssignableFrom((Class)possibility$1._1());
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$2(Tuple2 possibility$1, Tuple2 x$2) {
        return BoxesRunTime.equals((Object)x$2._2(), (Object)possibility$1._2());
    }

    private static final boolean unique$1(Seq possibilities) {
        Tuple2 possibility;
        return possibilities.size() == 1 || possibilities.forall(arg_0 -> Serialization.$anonfun$serializerFor$1$adapted(possibility = (Tuple2)possibilities.head(), arg_0)) || possibilities.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$2(possibility, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$3(Class clazz$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((Class)x0$1._1()).isAssignableFrom(clazz$3);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$4(Tuple2 x0$2) {
        if (x0$2 != null && x0$2._2() instanceof JavaSerializer) {
            return false;
        }
        return x0$2 == null || !(x0$2._2() instanceof DisabledJavaSerializer);
    }

    public static final /* synthetic */ boolean $anonfun$serializers$1(Tuple2 check$ifrefutable$1) {
        if (check$ifrefutable$1 != null) {
            String k = (String)check$ifrefutable$1._1();
            String v = (String)check$ifrefutable$1._2();
            if (k != null && v != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$1(Tuple2 check$ifrefutable$2) {
        if (check$ifrefutable$2 != null) {
            String className = (String)check$ifrefutable$2._1();
            String alias = (String)check$ifrefutable$2._2();
            if (className != null && alias != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$2(Serialization $this, Tuple2 x$4) {
        if (x$4 != null) {
            String className = (String)x$4._1();
            String alias = (String)x$4._2();
            if (className != null && alias != null) {
                return !alias.equals("none") && $this.checkGoogleProtobuf(className);
            }
        }
        throw new MatchError((Object)x$4);
    }

    public static final /* synthetic */ boolean $anonfun$bindings$7(Serialization $this, Tuple2 x0$3) {
        if (x0$3 != null) {
            Class clazz = (Class)x0$3._1();
            Serializer ser = (Serializer)x0$3._2();
            return $this.warnUnexpectedNonPekkoSerializer(clazz, ser);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$ensureOnlyAllowedSerializers$1(Serialization $this, Serializer x$6) {
        return !$this.org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer(x$6);
    }

    public static final /* synthetic */ boolean $anonfun$sort$2(Tuple2 ca$1, Tuple2 x$7) {
        return ((Class)x$7._1()).isAssignableFrom((Class)ca$1._1());
    }

    public static final /* synthetic */ void $anonfun$quickSerializerByIdentity$1(int size$1, Serializer[] table$1, Tuple2 x0$6) {
        if (x0$6 != null) {
            int id = x0$6._1$mcI$sp();
            Serializer ser = (Serializer)x0$6._2();
            if (0 <= id && id < size$1) {
                table$1[id] = ser;
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    private final boolean suppressWarningOnNonSerializationVerification$1(Class serializedClass) {
        return !this.isWarningOnNoVerificationEnabled() && NoSerializationVerificationNeeded.class.isAssignableFrom(serializedClass);
    }

    /*
     * WARNING - void declaration
     */
    public Serialization(ExtendedActorSystem system) {
        void var3_3;
        Vector vector;
        this.system = system;
        this.settings = new Settings(system.settings().config());
        this.AllowJavaSerialization = system.settings().AllowJavaSerialization();
        this._log = Logging$.MODULE$.withMarker(system, this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.log = this._log;
        this.manifestCache = new AtomicReference<scala.collection.immutable.Map>(Predef$.MODULE$.Map().empty());
        Option option = system.settings().setup().get(ClassTag$.MODULE$.apply(SerializationSetup.class));
        if (None$.MODULE$.equals(option)) {
            vector = package$.MODULE$.Vector().empty();
        } else if (option instanceof Some) {
            vector = (Seq)((SerializationSetup)((Some)option).value()).createSerializers().apply((Object)system);
        } else {
            throw new MatchError(option);
        }
        this.serializerDetails = (Seq)vector.collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;

            /*
             * WARNING - void declaration
             */
            public final <A1 extends SerializerDetails, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null && this.$outer.org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer(x1.serializer())) {
                    void apply_useFor;
                    void apply_serializer;
                    this.$outer.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `pekko.actor.allow-java-serialization = off`.");
                    Seq<Class<?>> seq = x1.useFor();
                    DisabledJavaSerializer disabledJavaSerializer = new DisabledJavaSerializer(this.$outer.system());
                    String apply_alias = x1.alias();
                    return (B1)new SerializerDetails(apply_alias, (Serializer)apply_serializer, (Seq<Class<?>>)apply_useFor);
                }
                return (B1)x1;
            }

            public final boolean isDefinedAt(SerializerDetails x1) {
                if (x1 != null && this.$outer.org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer(x1.serializer())) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        scala.collection.immutable.Map result = (scala.collection.immutable.Map)((scala.collection.immutable.Map)this.settings().Serializers().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializers$1(check$ifrefutable$1))).map((Function1 & Serializable)x$3 -> {
            if (x$3 != null) {
                String k = (String)x$3._1();
                String v = (String)x$3._2();
                if (k != null && v != null) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), this.serializerOf(k, v).get());
                }
            }
            throw new MatchError(x$3);
        })).$plus$plus((IterableOnce)this.serializerDetails().map((Function1 & Serializable)d -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)d.alias()), (Object)d.serializer())));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)result.iterator().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                return (Serializer)x0$1._2();
            }
            throw new MatchError(null);
        }));
        this.serializers = var3_3;
        scala.collection.immutable.Map fromConfig = (scala.collection.immutable.Map)this.settings().SerializationBindings().withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$1(check$ifrefutable$2))).withFilter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$2(this, x$4))).map((Function1 & Serializable)x$5 -> {
            if (x$5 != null) {
                String className = (String)x$5._1();
                String alias = (String)x$5._2();
                if (className != null && alias != null) {
                    return new Tuple2(this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).get(), this.serializers().apply((Object)alias));
                }
            }
            throw new MatchError(x$5);
        });
        Seq fromSettings = (Seq)this.serializerDetails().flatMap((Function1 & Serializable)detail -> (Seq)detail.useFor().map((Function1 & Serializable)clazz -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(clazz), (Object)detail.serializer())));
        Seq<Tuple2<Class<?>, Serializer>> result2 = this.sort((Iterable)fromConfig.$plus$plus((IterableOnce)fromSettings));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)result2.iterator().map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                return (Serializer)x0$2._2();
            }
            throw new MatchError(null);
        }));
        result2.foreach((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$7(this, x0$3)));
        this.bindings = result2;
        this.serializerMap = (ConcurrentHashMap)this.bindings().foldLeft(new ConcurrentHashMap(), (Function2 & Serializable)(x0$4, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$4, x1$1);
            if (x1$1 != null) {
                Class c = (Class)x1$1._1();
                Serializer s = (Serializer)x1$1._2();
                x0$4.put(c, s);
                return x0$4;
            }
            throw new MatchError((Object)tuple2);
        });
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)NullSerializer$.MODULE$);
        scala.collection.immutable.Map zero = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.serializerByIdentity = (scala.collection.immutable.Map)this.serializers().foldLeft((Object)zero, (Function2 & Serializable)(x0$5, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$5, x1$2);
            if (x1$2 != null) {
                Serializer ser = (Serializer)x1$2._2();
                int id = ser.identifier();
                Option option = x0$5.get((Object)BoxesRunTime.boxToInteger((int)id));
                if (option instanceof Some) {
                    Serializer serializer = (Serializer)((Some)option).value();
                    if (serializer == null || !serializer.equals(ser)) {
                        throw new IllegalArgumentException(new StringBuilder(68).append("Serializer identifier [").append(id).append("] of [").append(ser.getClass().getName()).append("] ").append("is not unique. It is also used by [").append(x0$5.apply((Object)BoxesRunTime.boxToInteger((int)id)).getClass().getName()).append("].").toString());
                    }
                }
                return (scala.collection.immutable.Map)x0$5.updated((Object)BoxesRunTime.boxToInteger((int)id), (Object)ser);
            }
            throw new MatchError((Object)tuple2);
        });
        int size = 1024;
        Serializer[] table = new Serializer[size];
        this.serializerByIdentity().foreach((Function1 & Serializable)x0$6 -> {
            Serialization.$anonfun$quickSerializerByIdentity$1(size, table, x0$6);
            return BoxedUnit.UNIT;
        });
        this.quickSerializerByIdentity = table;
        this.isJavaSerializationWarningEnabled = this.settings().config().getBoolean("pekko.actor.warn-about-java-serializer-usage");
        this.isWarningOnNoVerificationEnabled = this.settings().config().getBoolean("pekko.actor.warn-on-no-serialization-verification");
    }

    public static final /* synthetic */ Object $anonfun$serializerFor$1$adapted(Tuple2 possibility$1, Tuple2 x$1) {
        return BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$1(possibility$1, x$1));
    }

    public static final class Information
    implements Product,
    Serializable {
        private final Address address;
        private final ActorSystem system;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Address address() {
            return this.address;
        }

        public ActorSystem system() {
            return this.system;
        }

        public Information copy(Address address, ActorSystem system) {
            return new Information(address, system);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public ActorSystem copy$default$2() {
            return this.system();
        }

        public String productPrefix() {
            return "Information";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.address();
                }
                case 1: {
                    return this.system();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Information;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "address";
                }
                case 1: {
                    return "system";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 1667767227, true);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof Information)) break block3;
                    Information information = (Information)x$1;
                    Address address = this.address();
                    Address address2 = information.address();
                    if (address != null ? !((Object)address).equals(address2) : address2 != null) break block3;
                    ActorSystem actorSystem = this.system();
                    ActorSystem actorSystem2 = information.system();
                    if (actorSystem != null ? !actorSystem.equals(actorSystem2) : actorSystem2 != null) break block3;
                }
                return true;
            }
            return false;
        }

        public Information(Address address, ActorSystem system) {
            this.address = address;
            this.system = system;
            Product.$init$((Product)this);
        }
    }

    public static class Settings {
        private final Config config;
        private final scala.collection.immutable.Map<String, String> Serializers;
        private final scala.collection.immutable.Map<String, String> SerializationBindings;

        public Config config() {
            return this.config;
        }

        public scala.collection.immutable.Map<String, String> Serializers() {
            return this.Serializers;
        }

        public scala.collection.immutable.Map<String, String> SerializationBindings() {
            return this.SerializationBindings;
        }

        private final scala.collection.immutable.Map<String, String> configToMap(Config cfg) {
            return (scala.collection.immutable.Map)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)package$JavaConverters$.MODULE$, (Map)cfg.root().unwrapped()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String k = (String)x0$1._1();
                    Object v = x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.toString());
                }
                throw new MatchError(null);
            });
        }

        public Settings(Config config) {
            this.config = config;
            this.Serializers = this.configToMap(config.getConfig("pekko.actor.serializers"));
            Config bindings = config.getConfig("pekko.actor.serialization-bindings");
            this.SerializationBindings = this.configToMap(bindings);
        }
    }
}

