/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.tsp.cms;

import java.net.URI;
import org.python.bouncycastle.asn1.ASN1Boolean;
import org.python.bouncycastle.asn1.ASN1IA5String;
import org.python.bouncycastle.asn1.ASN1UTF8String;
import org.python.bouncycastle.asn1.DERIA5String;
import org.python.bouncycastle.asn1.DERUTF8String;
import org.python.bouncycastle.asn1.cms.Attributes;
import org.python.bouncycastle.asn1.cms.MetaData;
import org.python.bouncycastle.cms.CMSException;
import org.python.bouncycastle.operator.DigestCalculator;
import org.python.bouncycastle.tsp.cms.MetaDataUtil;

public class CMSTimeStampedGenerator {
    protected MetaData metaData;
    protected URI dataUri;

    public void setDataUri(URI uRI) {
        this.dataUri = uRI;
    }

    public void setMetaData(boolean bl, String string2, String string3) {
        this.setMetaData(bl, string2, string3, null);
    }

    public void setMetaData(boolean bl, String string2, String string3, Attributes attributes) {
        DERUTF8String dERUTF8String = null;
        if (string2 != null) {
            dERUTF8String = new DERUTF8String(string2);
        }
        DERIA5String dERIA5String = null;
        if (string3 != null) {
            dERIA5String = new DERIA5String(string3);
        }
        this.setMetaData(bl, dERUTF8String, dERIA5String, attributes);
    }

    private void setMetaData(boolean bl, ASN1UTF8String aSN1UTF8String, ASN1IA5String aSN1IA5String, Attributes attributes) {
        this.metaData = new MetaData(ASN1Boolean.getInstance(bl), aSN1UTF8String, aSN1IA5String, attributes);
    }

    public void initialiseMessageImprintDigestCalculator(DigestCalculator digestCalculator) throws CMSException {
        MetaDataUtil metaDataUtil = new MetaDataUtil(this.metaData);
        metaDataUtil.initialiseMessageImprintDigestCalculator(digestCalculator);
    }
}

