/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service;

import com.xebialabs.deployit.core.rest.exception.StitchException;
import com.xebialabs.deployit.core.rest.exception.StitchException$;
import com.xebialabs.deployit.core.rest.view.PublishView;
import com.xebialabs.deployit.plugin.stitch.configuration.git.GitUserCredentials;
import com.xebialabs.deployit.plugin.stitch.model.ci.GitSource;
import com.xebialabs.deployit.plugin.stitch.service.GitOpsService;
import com.xebialabs.deployit.plugin.stitch.service.GitService;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.BranchSyncStarter$;
import com.xebialabs.deployit.plugin.stitch.service.util.GitCredentialsUtils$;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.service.UserCredentialsService;
import com.xebialabs.deployit.service.controltask.ControlTaskService;
import com.xebialabs.deployit.util.PasswordEncrypter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jgit.api.Git;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Using;
import scala.util.Using$;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001B\u0007\u000f\u0001mA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!A!\b\u0001BC\u0002\u0013\r1\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003=\u0011!!\u0005A!b\u0001\n\u0007)\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000b5\u0003A\u0011\u0001(\t\u000bQ\u0003A\u0011I+\t\u000bA\u0004A\u0011I9\t\u000bm\u0004A\u0011\t?\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u001a!9\u0011Q\b\u0001\u0005B\u0005}\"!\u0005#fM\u0006,H\u000e^$jiN+'O^5dK*\u0011q\u0002E\u0001\bg\u0016\u0014h/[2f\u0015\t\t\"#\u0001\u0004ti&$8\r\u001b\u0006\u0003'Q\ta\u0001\u001d7vO&t'BA\u000b\u0017\u0003!!W\r\u001d7ps&$(BA\f\u0019\u0003%AXMY5bY\u0006\u00147OC\u0001\u001a\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001AD\t\u0014\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\r\u0005s\u0017PU3g!\t\u0019C%D\u0001\u000f\u0013\t)cB\u0001\u0006HSR\u001cVM\u001d<jG\u0016\u0004\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\u000bMdg\r\u000e6\u000b\u0003-\n\u0001b\u001a:jujdW\rZ\u0005\u0003[!\u0012q\u0001T8hO&tw-A\u0007hSR|\u0005o]*feZL7-\u001a\t\u0003GAJ!!\r\b\u0003\u001b\u001dKGo\u00149t'\u0016\u0014h/[2f\u0003I\u0019wN\u001c;s_2$\u0016m]6TKJ4\u0018nY3\u0011\u0005QBT\"A\u001b\u000b\u0005Y:\u0014aC2p]R\u0014x\u000e\u001c;bg.T!a\u0004\u000b\n\u0005e*$AE\"p]R\u0014x\u000e\u001c+bg.\u001cVM\u001d<jG\u0016\fa#^:fe\u000e\u0013X\rZ3oi&\fGn]*feZL7-Z\u000b\u0002yA\u0011Q(Q\u0007\u0002})\u0011qb\u0010\u0006\u0003\u0001R\t\u0001b]3dkJLG/_\u0005\u0003\u0005z\u0012a#V:fe\u000e\u0013X\rZ3oi&\fGn]*feZL7-Z\u0001\u0018kN,'o\u0011:fI\u0016tG/[1mgN+'O^5dK\u0002\n\u0011\u0003]1tg^|'\u000fZ#oGJL\b\u000f^3s+\u00051\u0005CA$K\u001b\u0005A%BA%\u0015\u0003\u0011)H/\u001b7\n\u0005-C%!\u0005)bgN<xN\u001d3F]\u000e\u0014\u0018\u0010\u001d;fe\u0006\u0011\u0002/Y:to>\u0014H-\u00128def\u0004H/\u001a:!\u0003\u0019a\u0014N\\5u}Q)q\nU)S'B\u00111\u0005\u0001\u0005\u0006]\u001d\u0001\ra\f\u0005\u0006e\u001d\u0001\ra\r\u0005\u0006u\u001d\u0001\u001d\u0001\u0010\u0005\u0006\t\u001e\u0001\u001dAR\u0001\u000fm\u0006d\u0017\u000eZ1uK\n\u0013\u0018M\\2i)\r1\u0016l\u0019\t\u0003;]K!\u0001\u0017\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u00065\"\u0001\raW\u0001\nO&$8k\\;sG\u0016\u0004\"\u0001X1\u000e\u0003uS!AX0\u0002\u0005\rL'B\u00011\u0011\u0003\u0015iw\u000eZ3m\u0013\t\u0011WLA\u0005HSR\u001cv.\u001e:dK\")A\r\u0003a\u0001K\u0006Q!M]1oG\"t\u0015-\\3\u0011\u0005\u0019lgBA4l!\tAg$D\u0001j\u0015\tQ'$\u0001\u0004=e>|GOP\u0005\u0003Yz\ta\u0001\u0015:fI\u00164\u0017B\u00018p\u0005\u0019\u0019FO]5oO*\u0011ANH\u0001\u0005g\u00064X\r\u0006\u0004WeR4\bP\u001f\u0005\u0006g&\u0001\r!Z\u0001\nI&\u0014Xm\u0019;pefDQ!^\u0005A\u0002\u0015\fAAZ5mK\")q/\u0003a\u0001K\u000691m\u001c8uK:$\b\"B=\n\u0001\u0004)\u0017A\u00022sC:\u001c\u0007\u000eC\u0003[\u0013\u0001\u00071,A\u0004qk\nd\u0017n\u001d5\u0015\u000fu\fy!!\u0005\u0002\u0014A\u0019a0a\u0003\u000e\u0003}TA!!\u0001\u0002\u0004\u0005!a/[3x\u0015\u0011\t)!a\u0002\u0002\tI,7\u000f\u001e\u0006\u0004\u0003\u0013!\u0012\u0001B2pe\u0016L1!!\u0004\u0000\u0005-\u0001VO\u00197jg\"4\u0016.Z<\t\u000biS\u0001\u0019A.\t\u000b\u0011T\u0001\u0019A3\t\r\u0005U!\u00021\u0001f\u0003!)8/\u001a:oC6,\u0017!I<sSR,Gk\u001c$jY\u0016\fe\u000e\u001a*fiV\u0014hnQ8n[&$X*Z:tC\u001e,G#C3\u0002\u001c\u0005u\u0011qDA\u0011\u0011\u0015\u00198\u00021\u0001f\u0011\u0015)8\u00021\u0001f\u0011\u001598\u00021\u0001f\u0011\u001d\t\u0019c\u0003a\u0001\u0003K\t1aZ5u!\u0011\t9#!\u000f\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\t1!\u00199j\u0015\u0011\ty#!\r\u0002\t)<\u0017\u000e\u001e\u0006\u0005\u0003g\t)$A\u0004fG2L\u0007o]3\u000b\u0005\u0005]\u0012aA8sO&!\u00111HA\u0015\u0005\r9\u0015\u000e^\u0001\u0007I\u0016dW\r^3\u0015\u000bY\u000b\t%a\u0011\t\u000bic\u0001\u0019A.\t\u000b\u0011d\u0001\u0019A3)\u0007\u0001\t9\u0005\u0005\u0003\u0002J\u0005MSBAA&\u0015\u0011\ti%a\u0014\u0002\u0015M$XM]3pif\u0004XM\u0003\u0003\u0002R\u0005U\u0012aD:qe&twM\u001a:b[\u0016<xN]6\n\t\u0005U\u00131\n\u0002\b'\u0016\u0014h/[2fQ\r\u0001\u0011\u0011\f\t\u0005\u00037\nI'\u0004\u0002\u0002^)!\u0011qLA1\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003G\n)'A\u0004gC\u000e$xN]=\u000b\t\u0005\u001d\u0014qJ\u0001\u0006E\u0016\fgn]\u0005\u0005\u0003W\niFA\u0005BkR|w/\u001b:fI\u0002")
public class DefaultGitService
implements GitService,
Logging {
    private final GitOpsService gitOpsService;
    private final ControlTaskService controlTaskService;
    private final UserCredentialsService userCredentialsService;
    private final PasswordEncrypter passwordEncrypter;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public GitSource fetchGitSourceCi(String id) {
        return GitService.fetchGitSourceCi$(this, id);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultGitService defaultGitService = this;
        synchronized (defaultGitService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public UserCredentialsService userCredentialsService() {
        return this.userCredentialsService;
    }

    public PasswordEncrypter passwordEncrypter() {
        return this.passwordEncrypter;
    }

    @Override
    public void validateBranch(GitSource gitSource, String branchName) {
        if (!this.gitOpsService.getGitSourceBranchNames(gitSource).contains((Object)branchName)) {
            this.warn((Function0<Object>)(Function0 & Serializable)() -> "Validation of branch failed for [" + branchName + "] - check Git Source [" + gitSource.getName() + "] for existing branches.");
            throw new StitchException("Branch name [" + branchName + "] does not exist, check your git repository.", StitchException$.MODULE$.apply$default$2());
        }
    }

    @Override
    public void save(String directory, String file, String content, String branch, GitSource gitSource) {
        GitCredentialsUtils$.MODULE$.withCredentials((Function1 & Serializable)credentials -> {
            DefaultGitService.$anonfun$save$1(this, gitSource, branch, directory, file, content, credentials);
            return BoxedUnit.UNIT;
        }, this.userCredentialsService(), this.passwordEncrypter());
    }

    @Override
    public PublishView publish(GitSource gitSource, String branchName, String username) {
        GitCredentialsUtils$.MODULE$.withCredentials((Function1 & Serializable)credentials -> {
            DefaultGitService.$anonfun$publish$1(this, gitSource, branchName, credentials);
            return BoxedUnit.UNIT;
        }, this.userCredentialsService(), this.passwordEncrypter());
        BranchSyncStarter$.MODULE$.scanBranchesSource(this.controlTaskService, gitSource, gitSource.masterBranchName(), Permissions.getAuthentication());
        return new PublishView();
    }

    private String writeToFileAndReturnCommitMessage(String directory, String file, String content, Git git) {
        Path path;
        Option option = Option$.MODULE$.apply((Object)directory);
        if (option instanceof Some) {
            Some some = (Some)option;
            String directory2 = (String)some.value();
            path = Paths.get(git.getRepository().getDirectory().getParent() + "/" + directory2, new String[0]);
        } else if (None$.MODULE$.equals(option)) {
            path = Paths.get(git.getRepository().getDirectory().getParent(), new String[0]);
        } else {
            throw new MatchError((Object)option);
        }
        Path dir = path;
        Files.createDirectories(dir, new FileAttribute[0]);
        File myFile = new File(dir.toFile(), file);
        if (!myFile.exists()) {
            if (!myFile.createNewFile()) {
                throw new StitchException("Could not create file " + myFile, StitchException$.MODULE$.apply$default$2());
            }
            Using$.MODULE$.apply((Function0 & Serializable)() -> new PrintWriter(myFile), (Function1 & Serializable)printWriter -> {
                printWriter.write(content);
                return BoxedUnit.UNIT;
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$).getOrElse((Function0 & Serializable)() -> {
                throw new StitchException("Could not write to file " + myFile, StitchException$.MODULE$.apply$default$2());
            });
            return "Add rule file " + file;
        }
        Using$.MODULE$.apply((Function0 & Serializable)() -> new PrintWriter(new FileWriter(myFile, false)), (Function1 & Serializable)printWriter -> {
            printWriter.write(content);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$).getOrElse((Function0 & Serializable)() -> {
            throw new StitchException("Could not write to file " + myFile, StitchException$.MODULE$.apply$default$2());
        });
        return "Update rule file " + file;
    }

    @Override
    public void delete(GitSource gitSource, String branchName) {
        GitCredentialsUtils$.MODULE$.withCredentials((Function1 & Serializable)credentials -> {
            DefaultGitService.$anonfun$delete$1(this, gitSource, branchName, credentials);
            return BoxedUnit.UNIT;
        }, this.userCredentialsService(), this.passwordEncrypter());
    }

    public static final /* synthetic */ void $anonfun$save$1(DefaultGitService $this, GitSource gitSource$2, String branch$1, String directory$1, String file$1, String content$1, GitUserCredentials credentials) {
        Tuple3<Git, File, String> gitRepo = $this.gitOpsService.branchExists(credentials, gitSource$2, branch$1) ? $this.gitOpsService.cloneGitRepositoryBranch(credentials, gitSource$2, branch$1) : $this.gitOpsService.cloneGitRepositoryAndBranch(credentials, gitSource$2, branch$1);
        String message = $this.writeToFileAndReturnCommitMessage(directory$1, file$1, content$1, (Git)gitRepo._1());
        $this.gitOpsService.saveAndCommit(credentials, gitSource$2, (Git)gitRepo._1(), message);
        $this.gitOpsService.clean((Git)gitRepo._1(), (File)gitRepo._2());
    }

    public static final /* synthetic */ void $anonfun$publish$1(DefaultGitService $this, GitSource gitSource$3, String branchName$2, GitUserCredentials credentials) {
        $this.validateBranch(gitSource$3, branchName$2);
        $this.gitOpsService.mergeBranch(credentials, gitSource$3, branchName$2);
    }

    public static final /* synthetic */ void $anonfun$delete$1(DefaultGitService $this, GitSource gitSource$4, String branchName$3, GitUserCredentials credentials) {
        $this.validateBranch(gitSource$4, branchName$3);
        $this.gitOpsService.deleteBranch(credentials, gitSource$4, branchName$3);
    }

    public DefaultGitService(GitOpsService gitOpsService, ControlTaskService controlTaskService, UserCredentialsService userCredentialsService, PasswordEncrypter passwordEncrypter) {
        this.gitOpsService = gitOpsService;
        this.controlTaskService = controlTaskService;
        this.userCredentialsService = userCredentialsService;
        this.passwordEncrypter = passwordEncrypter;
        GitService.$init$(this);
        Logging.$init$((Logging)this);
    }
}

