package com.xebialabs.deployit.core.rest.xml;

import com.google.common.collect.Lists;
import com.thoughtworks.xstream.converters.Converter;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;

import static com.xebialabs.deployit.checks.Checks.checkState;

@Component
@Provider
@Produces({"application/*+xml", "text/*+xml"})
@Consumes({"application/*+xml", "text/*+xml"})
public class SpringXStreamReaderWriter extends XStreamReaderWriter implements ApplicationContextAware {

    private static final List<String> blacklistPackages = Lists.newArrayList(
            "com.xebialabs.deployit.booter.remote.xml",
            "com.xebialabs.deployit.taskexecution.xml"
    );
    private ApplicationContext applicationContext;

    public SpringXStreamReaderWriter() {
    }

    @Override
    @PostConstruct
    protected void init() {
        if (applicationContext != null) {
            super.init();
            XStreamReaderWriter.registerConfigurationItemAliases();
        }
    }

    @Override
    protected Converter constructConverter(Class<?> clazz) {
        if (blacklistPackages.contains(clazz.getPackage().getName())) {
            return null;
        }
        try {
            Object bean = applicationContext.getBean(clazz);
            checkState(bean instanceof Converter, "[%s] should be a Converter", bean);
            return (Converter) bean;
        } catch (BeansException be) {
            return super.constructConverter(clazz);
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            return super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
        } catch (RuntimeException e) {
            XStreamCiConverterWithRepository.clear();
            throw e;
        } finally {
            XStreamCiConverterWithRepository.postProcess();
        }
    }
}
