package ai.digital.engine.exportcis.route

import ai.digital.engine.exportcis.CisImportSupport
import com.xebialabs.xlplatform.endpoints.{AuthenticatedData, ExtensionRoutes}
import com.xebialabs.xlplatform.sugar.PathSugar._
import grizzled.slf4j.Logging
import org.apache.pekko.actor.ActorSystem
import org.apache.pekko.http.scaladsl.model.{HttpResponse, StatusCodes}
import org.apache.pekko.http.scaladsl.server.Route

import java.io.File

class ImportCisRoute extends ExtensionRoutes with Logging with CisImportSupport {

  def route(system: ActorSystem): AuthenticatedData => Route = (auth: AuthenticatedData) => pathPrefix("import" / "citree") {
    post {
      rejectNonAdmin(auth) {
        parameter(Symbol("from")) { archiveLocation =>
          complete {
            new File(archiveLocation) match {
              case archiveFile if archiveFile.isFile => `import`(archiveFile)(auth)
              case _ => HttpResponse(StatusCodes.NotFound, entity = s"Could not find an archive at [$archiveLocation]")
            }
          }
        }
      }
    }
  }
}
