package com.xebialabs.deployit.deployment.rules;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.flow.Step;

import java.util.Arrays;

/**
 * This Bridge class exists because the two implemented methods lead to the following error if implemented in scala:
 *
 * [ant:scalac] ...xl-deploy/engine/planner/src/main/scala/com/xebialabs/deployit/deployment/rules/RulePlanningContext.scala:72: error: double definition:
 * [ant:scalac] override def addSteps(steps: com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep*): Unit at line 68 and
 * [ant:scalac] override def addSteps(steps: com.xebialabs.deployit.plugin.api.flow.Step*): Unit at line 72
 * [ant:scalac] have same type after erasure: (steps: Seq)Unit
 * [ant:scalac]   override def addSteps(steps: Step*): Unit = wrappedContext.addSteps(steps.toList)
 */
public abstract class ScalaJavaBridgeDeploymentPlanningContext implements DeploymentPlanningContext {

    @Override
    public void addSteps(DeploymentStep... steps) {
        this.addSteps(Arrays.asList(steps));
    }

    @Override
    public void addSteps(Step... steps) {
        this.addSteps(Arrays.asList(steps));
    }
}
