package ai.digital.deploy.permissions.configuration

import liquibase.integration.spring.SpringLiquibase

import javax.sql.DataSource

abstract class BaseLiquibaseConfiguration {
  protected def init(dataSource: DataSource): SpringLiquibase = {
    val lb = new SpringLiquibase()
    lb.setChangeLog("classpath:/db/deploy-permission-service-changelog.yaml")
    lb.setDataSource(dataSource)
    lb.setShouldRun(true)
    lb
  }
}
