package ai.digital.deploy.permissions.model

import org.hibernate.envers.Audited

import javax.persistence._

@Entity
@Table(name = "ps_role_principal")
@Audited
class RolePrincipal extends RoleFkModel {
  @Column(name = "principal_name")
  var principalName: String = _

  override def toString = s"RolePrincipal($id, $role, $principalName)"
}

object RolePrincipal {
  def apply(role: Role, principalName: String): RolePrincipal = {
    val rolePrincipal = new RolePrincipal
    rolePrincipal.role = role
    rolePrincipal.principalName = principalName
    rolePrincipal
  }
}
