package ai.digital.deploy.permissions.model.view

import ai.digital.deploy.permissions.model.converter.DateConverter
import org.hibernate.annotations.{Immutable, Type}

import java.time.LocalDateTime
import java.util.UUID
import javax.persistence._

class GlobalPermissionHistoryId extends Serializable {
  @Column(name = "global_permission_id")
  @Type(`type` = UuidCharType)
  var globalPermissionId: UUID = _

  @Column(name = "start_time")
  @Convert(converter = classOf[DateConverter])
  var startTime: LocalDateTime = _
}

@Entity
@Immutable
@IdClass(classOf[GlobalPermissionHistoryId])
@Table(name = "ps_global_permission_history")
class GlobalPermissionHistory extends HistoryPermissionEntity {
  @Id
  @Column(name = "global_permission_id")
  @Type(`type` = UuidCharType)
  var globalPermissionId: UUID = _
}

object GlobalPermissionHistory {
  def apply(startTime: LocalDateTime,
            endTime: LocalDateTime,
            permissionName: String,
            roleId: UUID,
            globalPermissionId: UUID,
            revisionType: Int
  ) = {
    val history = new GlobalPermissionHistory()
    history.revisionType = revisionType
    history.startTime = startTime
    history.endTime = endTime
    history.permissionName = permissionName
    history.roleId = roleId
    history.globalPermissionId = globalPermissionId
    history
  }
}
