package ai.digital.deploy.permissions.model.view

import org.hibernate.annotations.{Immutable, Type}

import java.util.UUID
import javax.persistence._

class RolePrincipalReferenceViewId extends Serializable {
  var roleId: UUID = _
  var principalName: String = _
  var reference: UUID = _
}

@Entity
@Immutable
@IdClass(classOf[RolePrincipalReferenceViewId])
@Table(name = "ps_role_principal_reference_view")
class RolePrincipalReferenceView {
  @Id
  @Column(name = "role_id")
  @Type(`type` = UuidCharType)
  var roleId: UUID = _
  @Column(name = "role_name")
  var roleName: String = _
  @Id
  @Column(name = "principal_name")
  var principalName: String = _
  @Id
  @Column(name = "reference")
  @Type(`type` = UuidCharType)
  var reference: UUID = _
}

object RolePrincipalReferenceView {
  def apply(
    roleId: UUID,
    roleName: String,
    principalName: String,
    reference: UUID
  ): RolePrincipalReferenceView = {
    val view = new RolePrincipalReferenceView()
    view.roleId = roleId
    view.roleName = roleName
    view.principalName = principalName
    view.reference = reference
    view
  }
}
