package ai.digital.deploy.permissions.repository

import ai.digital.deploy.permissions.model.view.GlobalPermissionHistory
import org.springframework.data.domain.{Page, Pageable}

import java.time.LocalDateTime
import java.util.UUID

trait GlobalPermissionHistoryRepository {
  def get(globalPermissionId: UUID): List[GlobalPermissionHistory]
  def get(permissionName: String): List[GlobalPermissionHistory]
  def getGlobalPermissionHistoriesForRole(roleId: UUID): List[GlobalPermissionHistory]
  def getGlobalPermissionHistoriesForRoleBetween(roleId: UUID,
                                                 startTime: LocalDateTime,
                                                 endTime: LocalDateTime
  ): List[GlobalPermissionHistory]
  def getGlobalPermissionHistoryBetween(globalPermissionId: UUID,
                                        startTime: LocalDateTime,
                                        endTime: LocalDateTime
  ): List[GlobalPermissionHistory]
  def getGlobalPermissionHistoryBetween(permissionName: String,
                                        startTime: LocalDateTime,
                                        endTime: LocalDateTime
  ): List[GlobalPermissionHistory]
  def getGlobalPermissionHistories(startTime: LocalDateTime, endTime: LocalDateTime): List[GlobalPermissionHistory]

  def findAllGlobalPermissionHistoriesForRole(roleId: UUID, pageable: Pageable): Page[GlobalPermissionHistory]
  def findAllGlobalPermissionHistoriesForRoleBetween(roleId: UUID,
                                                     startTime: LocalDateTime,
                                                     endTime: LocalDateTime,
                                                     pageable: Pageable
  ): Page[GlobalPermissionHistory]
  def findGlobalPermissionHistories(globalPermissionId: UUID,
                                    startTime: LocalDateTime,
                                    endTime: LocalDateTime,
                                    pageable: Pageable
  ): Page[GlobalPermissionHistory]
  def findGlobalPermissionHistories(permissionName: String,
                                    startTime: LocalDateTime,
                                    endTime: LocalDateTime,
                                    pageable: Pageable
  ): Page[GlobalPermissionHistory]
  def findGlobalPermissionHistories(startTime: LocalDateTime,
                                    endTime: LocalDateTime,
                                    pageable: Pageable
  ): Page[GlobalPermissionHistory]
}
