package ai.digital.deploy.permissions.repository

import ai.digital.deploy.permissions.model.{GlobalPermission, Role}
import org.springframework.data.domain.{Page, Pageable}

import java.util.UUID

trait GlobalPermissionRepository {
  def get(): List[GlobalPermission]

  def get(role: Role): List[GlobalPermission]

  def get(roleId: UUID): List[GlobalPermission]

  def get(roleName: String): List[GlobalPermission]

  def get(roleNames: List[String]): List[GlobalPermission]

  def getByPermissionsAndRoles(permissions: List[String], roleNames: Set[String]): List[GlobalPermission]

  def add(globalPermissions: GlobalPermission): GlobalPermission

  def add(globalPermissions: List[GlobalPermission]): List[GlobalPermission]

  def list(pageable: Pageable): Page[GlobalPermission]

  def listByRoleNamePattern(roleNamePattern: String, pageable: Pageable): Page[GlobalPermission]

  def listByRoleNamePattern(roleNamePattern: String): List[GlobalPermission]

  def remove(globalPermission: GlobalPermission): Unit

  def remove(globalPermissions: List[GlobalPermission]): Unit

  def removeForRole(role: Role): Unit

  def removeAll(): Unit
}
