package ai.digital.deploy.permissions.repository

import ai.digital.deploy.permissions.model.{Role, RolePrincipal}
import org.springframework.data.domain.{Page, Pageable}

trait RolePrincipalRepository {

  def get(): List[RolePrincipal]

  def get(principalName: String): List[RolePrincipal]

  def get(role: Role): List[RolePrincipal]

  def getAll(principals: List[String]): List[RolePrincipal]

  def add(rolePrincipal: RolePrincipal): RolePrincipal

  def add(rolePrincipals: List[RolePrincipal]): List[RolePrincipal]

  def list(pageable: Pageable): Page[RolePrincipal]

  def listByPrincipalNameAndRoleNamePattern(principalName: String,
                                            roleNamePattern: String,
                                            pageable: Pageable
  ): Page[RolePrincipal]

  def listByPrincipalName(principalName: String, pageable: Pageable): Page[RolePrincipal]

  def listByPrincipalNamesAndRoleNamePattern(principals: List[String],
                                             roleNamePattern: String,
                                             pageable: Pageable
  ): Page[RolePrincipal]

  def getByPrincipalsAndRolePattern(principals: List[String], rolePattern: String): List[RolePrincipal]

  def getByPrincipalAndRolePattern(principal: String, rolePattern: String): List[RolePrincipal]

  def getByRolePattern(rolePattern: String): List[RolePrincipal]

  def remove(role: RolePrincipal): Unit

  def remove(role: List[RolePrincipal]): Unit

  def removeForRole(role: Role): Unit

  def removeAll(): Unit
}
