package ai.digital.deploy.permissions.repository.jpa

import ai.digital.deploy.permissions.jpa.TransactionalPermissionRepository
import ai.digital.deploy.permissions.model.view.{RoleReferencedPermissionView, RoleReferencedPermissionViewId}
import ai.digital.deploy.permissions.repository.RoleReferencedPermissionViewRepository

import java.util.UUID
import ai.digital.deploy.permissions.model.view.RoleReferencedPermissionView
import org.springframework.data.jpa.repository.JpaRepository
import org.springframework.stereotype.Repository

import scala.jdk.CollectionConverters._
import java.util.{List => JList}

@Repository
@TransactionalPermissionRepository
trait RoleReferencedPermissionViewRepositoryImpl
    extends RoleReferencedPermissionViewRepository
    with JpaRepository[RoleReferencedPermissionView, RoleReferencedPermissionViewId] {
  override def get(roleIds: List[UUID], reference: UUID): List[RoleReferencedPermissionView] =
    findAllByRoleIdInAndReference(roleIds.asJava, reference).asScala.toList

  protected def findAllByRoleIdInAndReference(roleId: JList[UUID], reference: UUID): JList[RoleReferencedPermissionView]
}
