package ai.digital.deploy.permissions.service

import ai.digital.deploy.permissions.model.{GlobalPermission, Role}

import java.util.UUID

trait GlobalPermissionService {
  def add(roleName: String, permissions: List[String]): (Role, List[GlobalPermission])
  def remove(roleName: String, permissions: List[String]): (Role, List[GlobalPermission])
  def removeForRole(role: Role): Unit
  def removeAll(): Unit
  def read(): List[GlobalPermission]
  def read(roleName: String): List[GlobalPermission]
  def read(roleNames: List[String]): List[GlobalPermission]
  def readByRolePattern(rolePattern: String): List[GlobalPermission]
  def edit(roleName: String, permissionsToAdd: List[String], permissionsToDelete: List[String]): (Role, List[GlobalPermission])
  def getGlobalPermissionsForRoleId(roleId: UUID): List[String]
  def getGlobalPermissionsForPrincipal(principal: String): Set[String]
  def checkPermission(permissions: List[String], allRoles: List[String]): Boolean
  def checkPermission(permissions: List[String], allRoles: List[String], principals: List[String]): Boolean
}
