package ai.digital.deploy.permissions.service

import ai.digital.deploy.permissions.model.view.ReferencedPermissionHistory
import org.springframework.data.domain.{Page, Pageable}

import java.time.LocalDateTime
import java.util.UUID

trait ReferencedPermissionHistoryService {
  def listReferencesByRoleAndPermissions(roleId: UUID,
                                         permissions: List[String],
                                         startTime: LocalDateTime,
                                         endTime: LocalDateTime
  ): List[ReferencedPermissionHistory]
  def listReferencesByPrincipalAndPermissions(principalName: String,
                                              permissions: List[String],
                                              startTime: LocalDateTime,
                                              endTime: LocalDateTime
  ): List[ReferencedPermissionHistory]
  def listReferencesByRoleAndReferenceAndPermissions(roleId: UUID,
                                                     reference: UUID,
                                                     permissions: List[String],
                                                     startTime: LocalDateTime,
                                                     endTime: LocalDateTime
  ): List[ReferencedPermissionHistory]
  def listReferencesByPrincipalAndReferenceAndPermissions(principalName: String,
                                                          reference: UUID,
                                                          permissions: List[String],
                                                          startTime: LocalDateTime,
                                                          endTime: LocalDateTime
  ): List[ReferencedPermissionHistory]

  def getReferenceHistoriesForReferenceAndPermission(referenceId: UUID,
                                                     permission: String,
                                                     startTime: LocalDateTime,
                                                     endTime: LocalDateTime,
                                                     pageable: Pageable
  ): Page[ReferencedPermissionHistory]
  def getReferenceHistoriesForRoleId(roleId: UUID, pageable: Pageable): Page[ReferencedPermissionHistory]
  def getReferenceHistoriesForReferenceAndRoleId(referenceId: UUID,
                                                 roleId: UUID,
                                                 startTime: LocalDateTime,
                                                 endTime: LocalDateTime,
                                                 pageable: Pageable
  ): Page[ReferencedPermissionHistory]
  def getReferenceHistoriesForReferenceAndReferencedPermissionId(referenceId: UUID,
                                                                 referencedPermissionId: UUID,
                                                                 startTime: LocalDateTime,
                                                                 endTime: LocalDateTime,
                                                                 pageable: Pageable
  ): Page[ReferencedPermissionHistory]
}
