package ai.digital.deploy.permissions.service

import ai.digital.deploy.permissions.model.{Role, RolePrincipal}
import ai.digital.deploy.permissions.model.view.RolePrincipalReferenceView
import org.springframework.data.domain.{Page, Pageable}

import java.util.UUID

trait RolePrincipalService {
  def add(roleName: String, principals: List[String]): (Role, List[RolePrincipal])
  def remove(roleName: String, principals: List[String]): (Role, List[RolePrincipal])
  def removeForRole(role: Role): Unit
  def read(roleName: String): List[RolePrincipal]
  def read(roleNamePattern: String, pageable: Pageable): (Page[Role], List[RolePrincipal])
  def read(principalName: String, roleNamePattern: String, pageable: Pageable): Page[RolePrincipal]
  def read(principals: List[String], roleNamePattern: String, pageable: Pageable): Page[RolePrincipal]
  def read(referenceId: UUID, roleNamePattern: String, pageable: Pageable): (Page[Role], List[RolePrincipalReferenceView])
  def readByRolePattern(rolePattern: String): List[RolePrincipal]
  def read(principal: String, rolePattern: String): List[RolePrincipal]
  def read(principals: List[String], rolePattern: String): List[RolePrincipal]
  def readAll(principals: List[String]): List[RolePrincipal]
  def edit(roleName: String, principalsToAdd: List[String], principalsToDelete: List[String]): (Role, List[RolePrincipal])
}
