package ai.digital.deploy.permissions.service

import ai.digital.deploy.permissions.model.Role
import org.springframework.data.domain.{Page, Pageable}

import java.util.UUID

trait RoleService {
  def create(name: String): Role

  def createOrUpdate(role: Role): Role

  def delete(name: String): Unit

  def delete(id: UUID): Unit

  def deleteAllRoleReferences(roleName: String): Unit

  def removeAll(): Unit

  def remove(role: Role): Unit

  def update(role: Role): Role

  def rename(name: String, newName: String): Role

  def read(name: String): Option[Role]

  def read(names: List[String]): List[Role]

  def read(names: List[String], pageable: Pageable): Page[Role]

  def read(id: UUID): Option[Role]

  def read(namePattern: String, pageable: Pageable): Page[Role]

  def readByRolePattern(namePattern: String): List[Role]

  def readAll(): List[Role]

  def count(roleNamePattern: String): Long
}
