package ai.digital.deploy.permissions.service.impl

import ai.digital.deploy.permissions.jpa.TransactionalPermissionService
import ai.digital.deploy.permissions.model.view.GlobalPermissionHistory
import ai.digital.deploy.permissions.repository.GlobalPermissionHistoryRepository
import ai.digital.deploy.permissions.service.GlobalPermissionHistoryService
import org.springframework.data.domain.{Page, Pageable}
import org.springframework.stereotype.Service

import java.time.LocalDateTime
import java.util.UUID

@Service
@TransactionalPermissionService
class GlobalPermissionHistoryServiceImpl(globalPermissionHistoryRepository: GlobalPermissionHistoryRepository)
    extends GlobalPermissionHistoryService {
  override def getGlobalPermissionHistoriesForGlobalPermissionId(globalPermissionId: UUID,
                                                                 startTime: LocalDateTime,
                                                                 endTime: LocalDateTime,
                                                                 pageable: Pageable
  ): Page[GlobalPermissionHistory] =
    globalPermissionHistoryRepository.findGlobalPermissionHistories(globalPermissionId, startTime, endTime, pageable)

  override def getGlobalPermissionHistoriesForPermissionName(permissionName: String,
                                                             startTime: LocalDateTime,
                                                             endTime: LocalDateTime,
                                                             pageable: Pageable
  ): Page[GlobalPermissionHistory] =
    globalPermissionHistoryRepository.findGlobalPermissionHistories(permissionName, startTime, endTime, pageable)

  override def getGlobalPermissionHistoriesForRoleId(roleId: UUID,
                                                     startTime: LocalDateTime,
                                                     endTime: LocalDateTime,
                                                     pageable: Pageable
  ): Page[GlobalPermissionHistory] =
    globalPermissionHistoryRepository.findAllGlobalPermissionHistoriesForRoleBetween(roleId, startTime, endTime, pageable)
}
