package ai.digital.deploy.permissions.service.impl

import ai.digital.deploy.permissions.jpa.TransactionalPermissionService
import ai.digital.deploy.permissions.model.view.RolePrincipalHistory
import ai.digital.deploy.permissions.repository.RolePrincipalHistoryRepository
import ai.digital.deploy.permissions.service.RolePrincipalHistoryService
import org.springframework.data.domain.{Page, Pageable}
import org.springframework.stereotype.Service

import java.time.LocalDateTime
import java.util.UUID

@Service
@TransactionalPermissionService
class RolePrincipalHistoryServiceImpl(rolePrincipalHistoryRepository: RolePrincipalHistoryRepository)
    extends RolePrincipalHistoryService {
  override def getRolePrincipalHistoriesForPrincipalName(principalName: String,
                                                         startTime: LocalDateTime,
                                                         endTime: LocalDateTime,
                                                         pageable: Pageable
  ): Page[RolePrincipalHistory] =
    rolePrincipalHistoryRepository.findRolePrincipalHistories(principalName, startTime, endTime, pageable)

  override def getRolePrincipalHistoriesForRoleID(roleId: UUID,
                                                  startTime: LocalDateTime,
                                                  endTime: LocalDateTime,
                                                  pageable: Pageable
  ): Page[RolePrincipalHistory] =
    rolePrincipalHistoryRepository.findAllRolePrincipalHistoriesForRoleBetween(roleId, startTime, endTime, pageable)

  override def getRolePrincipalHistoriesForRolePrincipalId(rolePrincipalId: UUID,
                                                           startTime: LocalDateTime,
                                                           endTime: LocalDateTime,
                                                           pageable: Pageable
  ): Page[RolePrincipalHistory] =
    rolePrincipalHistoryRepository.findRolePrincipalHistories(rolePrincipalId, startTime, endTime, pageable)
}
