package ai.digital.deploy.permissions.model

import org.hibernate.annotations.Type
import org.hibernate.envers.Audited

import javax.persistence.{FetchType, JoinColumn, ManyToOne, MappedSuperclass}

@MappedSuperclass
abstract class RoleFkModel extends BaseModel {
  @Type(`type` = "uuid-char")
  @JoinColumn(name = "role_id")
  @ManyToOne(fetch = FetchType.LAZY)
  @Audited
  var role: Role = _
}
