package ai.digital.deploy.permissions.model.view

import ai.digital.deploy.permissions.model.converter.DateConverter

import java.time.LocalDateTime
import javax.persistence.{Column, Convert, Id, MappedSuperclass}

@MappedSuperclass
abstract class HistoryEntity extends Serializable {
  @Column(name = "REV_TYPE")
  var revisionType: Int = _

  @Id
  @Column(name = "start_time")
  @Convert(converter = classOf[DateConverter])
  var startTime: LocalDateTime = _

  @Column(name = "end_time")
  @Convert(converter = classOf[DateConverter])
  var endTime: LocalDateTime = _
}
