package ai.digital.deploy.permissions.model.view

import ai.digital.deploy.permissions.model.converter.DateConverter
import org.hibernate.annotations.{Immutable, Type}

import java.time.LocalDateTime
import java.util.UUID
import javax.persistence._

class RolePrincipalHistoryId extends Serializable {
  @Column(name = "role_principal_id")
  @Type(`type` = UuidCharType)
  var rolePrincipalId: UUID = _

  @Column(name = "start_time")
  @Convert(converter = classOf[DateConverter])
  var startTime: LocalDateTime = _
}

@Entity
@Immutable
@IdClass(classOf[RolePrincipalHistoryId])
@Table(name = "ps_role_principal_history")
class RolePrincipalHistory extends HistoryEntity {
  @Id
  @Column(name = "role_principal_id")
  @Type(`type` = UuidCharType)
  var rolePrincipalId: UUID = _

  @Column(name = "principal_name")
  var principalName: String = _

  @Column(name = "role_id")
  @Type(`type` = UuidCharType)
  var roleId: UUID = _
}

object RolePrincipalHistory {
  def apply(startTime: LocalDateTime,
            endTime: LocalDateTime,
            rolePrincipalId: UUID,
            principalName: String,
            roleId: UUID,
            revisionType: Int
  ) = {
    val rolePrincipalHistory = new RolePrincipalHistory()
    rolePrincipalHistory.revisionType = revisionType
    rolePrincipalHistory.startTime = startTime
    rolePrincipalHistory.endTime = endTime
    rolePrincipalHistory.rolePrincipalId = rolePrincipalId
    rolePrincipalHistory.principalName = principalName
    rolePrincipalHistory.roleId = roleId
    rolePrincipalHistory
  }
}
