package ai.digital.deploy.permissions.repository

import ai.digital.deploy.permissions.model.view.ReferencedPermissionHistory
import org.springframework.data.domain.{Page, Pageable}

import java.time.LocalDateTime
import java.util.UUID

trait ReferencedPermissionHistoryRepository {
  def get(referencedPermissionId: UUID, reference: UUID): List[ReferencedPermissionHistory]
  def get(permissionName: String, reference: UUID): List[ReferencedPermissionHistory]
  def getReferencedPermissionHistoriesForRole(roleId: UUID): List[ReferencedPermissionHistory]
  def getReferencedPermissionHistoriesForRoleAndPermissions(roleId: UUID,
                                                            permissionNames: List[String]
  ): List[ReferencedPermissionHistory]
  def getReferencedPermissionHistoriesForRoleAndReference(roleId: UUID,
                                                          reference: UUID,
                                                          permissionNames: List[String]
  ): List[ReferencedPermissionHistory]
  def getReferencedPermissionHistoriesForReferenceRoleBetween(roleId: UUID,
                                                              reference: UUID,
                                                              startTime: LocalDateTime,
                                                              endTime: LocalDateTime
  ): List[ReferencedPermissionHistory]
  def getReferencedPermissionHistoryBetween(referencedPermissionId: UUID,
                                            reference: UUID,
                                            startTime: LocalDateTime,
                                            endTime: LocalDateTime
  ): List[ReferencedPermissionHistory]
  def getReferencedPermissionHistoryBetween(permissionName: String,
                                            reference: UUID,
                                            startTime: LocalDateTime,
                                            endTime: LocalDateTime
  ): List[ReferencedPermissionHistory]

  def findAllReferencedPermissionHistoriesForRole(roleId: UUID, pageable: Pageable): Page[ReferencedPermissionHistory]
  def findAllReferencedPermissionHistoriesForReferenceRoleBetween(roleId: UUID,
                                                                  reference: UUID,
                                                                  startTime: LocalDateTime,
                                                                  endTime: LocalDateTime,
                                                                  pageable: Pageable
  ): Page[ReferencedPermissionHistory]
  def findReferencedPermissionHistories(referencedPermissionId: UUID,
                                        reference: UUID,
                                        startTime: LocalDateTime,
                                        endTime: LocalDateTime,
                                        pageable: Pageable
  ): Page[ReferencedPermissionHistory]
  def findReferencedPermissionHistories(permissionName: String,
                                        reference: UUID,
                                        startTime: LocalDateTime,
                                        endTime: LocalDateTime,
                                        pageable: Pageable
  ): Page[ReferencedPermissionHistory]
}
