package ai.digital.deploy.permissions.repository

import ai.digital.deploy.permissions.model.{ReferencedPermission, Role}
import org.springframework.data.domain.{Page, Pageable}

import java.util.UUID

trait ReferencedPermissionRepository {
  def get(roleName: String): List[ReferencedPermission]

  def get(roleNames: List[String]): List[ReferencedPermission]

  def get(reference: UUID): List[ReferencedPermission]

  def get(reference: UUID, role: Role): List[ReferencedPermission]

  def get(reference: UUID, roleName: String): List[ReferencedPermission]

  def getByPermissionsAndRoles(reference: UUID, permissions: List[String], roleNames: Set[String]): List[ReferencedPermission]

  def add(referencedPermission: ReferencedPermission): ReferencedPermission

  def add(referencedPermissions: List[ReferencedPermission]): List[ReferencedPermission]

  def list(pageable: Pageable): Page[ReferencedPermission]

  def listByRoleNamePattern(roleNamePattern: String, reference: UUID, pageable: Pageable): Page[ReferencedPermission]

  def listByRoleNamePattern(roleNamePattern: String, reference: UUID): List[ReferencedPermission]

  def listByRoleAndPermissions(roleId: UUID, permissionNames: List[String]): List[ReferencedPermission]

  def listByRolesAndPermissions(roleId: List[UUID], permissionNames: List[String]): List[ReferencedPermission]

  def listByRoleNameAndPermissions(roleName: String, permissionNames: List[String]): List[ReferencedPermission]

  def listByPrincipalNameAndPermissions(principalName: String, permissionNames: List[String]): List[ReferencedPermission]

  def remove(referencedPermissions: ReferencedPermission): Unit

  def remove(referencedPermissions: List[ReferencedPermission]): Unit

  def removeForRole(role: Role): Unit

  def removeForReference(referenceId: UUID): Unit

  def removeAll(): Unit
}
