package ai.digital.deploy.permissions.repository

import ai.digital.deploy.permissions.model.view.RolePrincipalHistory
import org.springframework.data.domain.{Page, Pageable}

import java.time.LocalDateTime
import java.util.UUID

trait RolePrincipalHistoryRepository {
  def get(rolePrincipalId: UUID): List[RolePrincipalHistory]
  def get(principalName: String): List[RolePrincipalHistory]
  def getRolePrincipalHistoriesForRole(roleId: UUID): List[RolePrincipalHistory]
  def getRolePrincipalHistoriesForRoleBetween(roleId: UUID,
                                              startTime: LocalDateTime,
                                              endTime: LocalDateTime
  ): List[RolePrincipalHistory]
  def getRolePrincipalHistoryBetween(rolePrincipalId: UUID,
                                     startTime: LocalDateTime,
                                     endTime: LocalDateTime
  ): List[RolePrincipalHistory]
  def getRolePrincipalHistoryBetween(principalName: String,
                                     startTime: LocalDateTime,
                                     endTime: LocalDateTime
  ): List[RolePrincipalHistory]
  def getRolePrincipalHistories(startTime: LocalDateTime, endTime: LocalDateTime): List[RolePrincipalHistory]

  def findAllRolePrincipalHistoriesForRole(roleId: UUID, pageable: Pageable): Page[RolePrincipalHistory]
  def findAllRolePrincipalHistoriesForRoleBetween(roleId: UUID,
                                                  startTime: LocalDateTime,
                                                  endTime: LocalDateTime,
                                                  pageable: Pageable
  ): Page[RolePrincipalHistory]
  def findRolePrincipalHistories(rolePrincipalId: UUID,
                                 startTime: LocalDateTime,
                                 endTime: LocalDateTime,
                                 pageable: Pageable
  ): Page[RolePrincipalHistory]
  def findRolePrincipalHistories(principalName: String,
                                 startTime: LocalDateTime,
                                 endTime: LocalDateTime,
                                 pageable: Pageable
  ): Page[RolePrincipalHistory]
  def findAllRolePrincipalHistories(startTime: LocalDateTime,
                                    endTime: LocalDateTime,
                                    pageable: Pageable
  ): Page[RolePrincipalHistory]
}
