package ai.digital.deploy.permissions.repository.jpa

import ai.digital.deploy.permissions.jpa.TransactionalPermissionRepository
import ai.digital.deploy.permissions.model.Role
import ai.digital.deploy.permissions.repository.RoleRepository
import org.springframework.data.domain.{Page, Pageable}
import org.springframework.data.jpa.repository.JpaRepository
import org.springframework.stereotype.Repository

import java.util.{Optional, UUID, List => JList}
import scala.jdk.CollectionConverters._
import scala.jdk.OptionConverters._

@Repository
@TransactionalPermissionRepository
trait RoleRepositoryImpl extends RoleRepository with JpaRepository[Role, UUID] {
  override def getAll(): List[Role] = findAll().asScala.toList
  override def get(name: String): Option[Role] = findByName(name).toScala
  override def get(names: List[String]): List[Role] = findByNameIn(names.asJava).asScala.toList
  override def get(names: List[String], pageable: Pageable): Page[Role] = findByNameIn(names.asJava, pageable)
  override def get(id: UUID): Option[Role] = findById(id).toScala
  override def countRolesByRoleNamePattern(roleNamePattern: String): Long =
    countByNameContainingIgnoreCase(roleNamePattern)
  override def countAllRoles(): Long =
    count()
  override def add(role: Role): Role = save(role)
  override def update(role: Role): Role = save(role)
  override def list(pageable: Pageable): Page[Role] = findAll(pageable)
  override def listByNamePattern(namePattern: String, pageable: Pageable): Page[Role] =
    findByNameContainingIgnoreCase(namePattern, pageable)
  def listByNamePattern(namePattern: String): List[Role] =
    findByNameContainingIgnoreCase(namePattern).asScala.toList
  override def remove(role: Role): Unit = delete(role)
  override def removeById(id: UUID): Unit = deleteById(id)
  override def removeAll(): Unit = deleteAll()

  protected def findByName(name: String): Optional[Role]
  protected def findByNameIn(names: JList[String]): JList[Role]
  protected def findByNameIn(names: JList[String], pageable: Pageable): Page[Role]
  protected def findByNameContainingIgnoreCase(name: String, pageable: Pageable): Page[Role]
  protected def findByNameContainingIgnoreCase(name: String): JList[Role]
  protected def countByNameContainingIgnoreCase(name: String): Long
}
