package ai.digital.deploy.permissions.model

import org.hibernate.annotations.JdbcTypeCode
import org.hibernate.envers.Audited

import java.util.UUID
import jakarta.persistence.{Column, Entity, Table}
import java.sql.Types.VARCHAR

@Entity
@Table(name = "ps_referenced_permission")
@Audited
class ReferencedPermission extends RoleFkModel {
  @Column(name = "permission_name")
  var permissionName: String = _

  @Column(name = "reference", length = 36)
  @JdbcTypeCode(VARCHAR)
  var reference: UUID = _

  override def toString = s"ReferencedPermission($id, $role, $permissionName, $reference)"
}

object ReferencedPermission {
  def apply(role: Role, permissionName: String, reference: UUID): ReferencedPermission = {
    val referencedPermissions = new ReferencedPermission
    referencedPermissions.role = role
    referencedPermissions.permissionName = permissionName
    referencedPermissions.reference = reference
    referencedPermissions
  }
}
