package ai.digital.deploy.permissions.model

import org.hibernate.annotations.JdbcTypeCode
import org.hibernate.envers.Audited
import jakarta.persistence.{FetchType, JoinColumn, ManyToOne, MappedSuperclass}
import java.sql.Types.VARCHAR

@MappedSuperclass
abstract class RoleFkModel extends BaseModel {
  @JdbcTypeCode(VARCHAR)
  @JoinColumn(name = "role_id")
  @ManyToOne(fetch = FetchType.LAZY)
  @Audited
  var role: Role = _
}
