package ai.digital.deploy.permissions.model.view

import ai.digital.deploy.permissions.model.converter.DateConverter
import org.hibernate.annotations.{Immutable, JdbcTypeCode}

import java.time.LocalDateTime
import java.util.UUID
import jakarta.persistence._
import java.sql.Types.VARCHAR

class RoleHistoryId extends Serializable {
  @Column(name = "role_id")
  @JdbcTypeCode(VARCHAR)
  var roleId: UUID = _

  @Column(name = "start_time")
  @Convert(converter = classOf[DateConverter])
  var startTime: LocalDateTime = _
}

@Entity
@Immutable
@IdClass(classOf[RoleHistoryId])
@Table(name = "ps_role_history")
class RoleHistory extends HistoryEntity {
  @Id
  @Column(name = "role_id")
  @JdbcTypeCode(VARCHAR)
  var roleId: UUID = _

  @Column(name = "role_name")
  var roleName: String = _
}
