package ai.digital.deploy.permissions.repository

import ai.digital.deploy.permissions.model.view.RoleHistory
import org.springframework.data.domain.{Page, Pageable}

import java.time.LocalDateTime
import java.util.UUID

trait RoleHistoryRepository {
  def get(roleId: UUID): List[RoleHistory]
  def getRoleHistoryBetween(roleId: UUID, startTime: LocalDateTime, endTime: LocalDateTime): List[RoleHistory]
  def getRoleHistories(startTime: LocalDateTime, endTime: LocalDateTime): List[RoleHistory]

  def findRoleHistories(roleId: UUID, startTime: LocalDateTime, endTime: LocalDateTime, pageable: Pageable): Page[RoleHistory]
  def findAllRoleHistories(startTime: LocalDateTime, endTime: LocalDateTime, pageable: Pageable): Page[RoleHistory]
}
