package ai.digital.deploy.permissions.service

import ai.digital.deploy.permissions.model.view.GlobalPermissionHistory
import org.springframework.data.domain.{Page, Pageable}

import java.time.LocalDateTime
import java.util.UUID

trait GlobalPermissionHistoryService {
  def getGlobalPermissionHistoriesForGlobalPermissionId(globalPermissionId: UUID,
                                                        startTime: LocalDateTime,
                                                        endTime: LocalDateTime,
                                                        pageable: Pageable
  ): Page[GlobalPermissionHistory]
  def getGlobalPermissionHistoriesForPermissionName(permissionName: String,
                                                    startTime: LocalDateTime,
                                                    endTime: LocalDateTime,
                                                    pageable: Pageable
  ): Page[GlobalPermissionHistory]
  def getGlobalPermissionHistoriesForRoleId(roleId: UUID,
                                            startTime: LocalDateTime,
                                            endTime: LocalDateTime,
                                            pageable: Pageable
  ): Page[GlobalPermissionHistory]
}
