package ai.digital.deploy.permissions.service

import ai.digital.deploy.permissions.model.view.RolePrincipalHistory
import org.springframework.data.domain.{Page, Pageable}

import java.time.LocalDateTime
import java.util.UUID

trait RolePrincipalHistoryService {
  def getRolePrincipalHistoriesForPrincipalName(principalName: String,
                                                startTime: LocalDateTime,
                                                endTime: LocalDateTime,
                                                pageable: Pageable
  ): Page[RolePrincipalHistory]
  def getRolePrincipalHistoriesForRoleID(roleId: UUID,
                                         startTime: LocalDateTime,
                                         endTime: LocalDateTime,
                                         pageable: Pageable
  ): Page[RolePrincipalHistory]
  def getRolePrincipalHistoriesForRolePrincipalId(rolePrincipalId: UUID,
                                                  startTime: LocalDateTime,
                                                  endTime: LocalDateTime,
                                                  pageable: Pageable
  ): Page[RolePrincipalHistory]
}
