package ai.digital.deploy.permissions.model.converter

import java.lang.{Long => JLong}
import java.sql.Timestamp
import java.time.LocalDateTime
import jakarta.persistence.{AttributeConverter, Converter}

@Converter
class DateConverter extends AttributeConverter[LocalDateTime, JLong] {
  override def convertToDatabaseColumn(attribute: LocalDateTime): JLong =
    Option(attribute).map(date => Long.box(Timestamp.valueOf(date).getTime)).orNull

  override def convertToEntityAttribute(dbData: JLong): LocalDateTime =
    Option(dbData).map(date => new Timestamp(date).toLocalDateTime()).orNull
}
