package ai.digital.deploy.permissions.model.view

import java.util.UUID
import jakarta.persistence._
import java.sql.Types.VARCHAR
import org.hibernate.annotations.{Immutable, JdbcTypeCode}

class RoleReferencedPermissionViewId extends Serializable {
  var roleId: UUID = _
  var permissionName: String = _
  var reference: UUID = _
}

@Entity
@Immutable
@IdClass(classOf[RoleReferencedPermissionViewId])
@Table(name = "ps_role_referenced_permission_view")
class RoleReferencedPermissionView {
  @Id
  @Column(name = "role_id")
  @JdbcTypeCode(VARCHAR)
  var roleId: UUID = _
  @Column(name = "role_name")
  var roleName: String = _
  @Id
  @Column(name = "permission_name")
  var permissionName: String = _
  @Id
  @Column(name = "reference")
  @JdbcTypeCode(VARCHAR)
  var reference: UUID = _
}

object RoleReferencedPermissionView {
  def apply(
    roleId: UUID,
    roleName: String,
    permissionName: String,
    reference: UUID
  ) = {
    val view = new RoleReferencedPermissionView()
    view.roleId = roleId
    view.roleName = roleName
    view.permissionName = permissionName
    view.reference = reference
    view
  }
}
