package ai.digital.deploy.permissions.repository

import ai.digital.deploy.permissions.model.Role
import org.springframework.data.domain.{Page, Pageable}

import java.util.UUID

trait RoleRepository {
  def get(name: String): Option[Role]

  def get(names: List[String]): List[Role]

  def get(names: List[String], pageable: Pageable): Page[Role]

  def get(id: UUID): Option[Role]

  def getAll(): List[Role]

  def countRolesByRoleNamePattern(roleNamePattern: String): Long

  def countAllRoles(): Long

  def add(role: Role): Role

  def update(role: Role): Role

  def list(pageable: Pageable): Page[Role]

  def listByNamePattern(namePattern: String, pageable: Pageable): Page[Role]

  def listByNamePattern(namePattern: String): List[Role]

  def remove(role: Role): Unit

  def removeById(id: UUID): Unit

  def removeAll(): Unit
}
