package ai.digital.deploy.permissions.configuration

import javax.sql.DataSource
import scala.util.Using

object JpaDialect {
  def initializeDialect(dataSource: DataSource): JpaDialect =
    Using(dataSource.getConnection) { connection =>
      connection.getMetaData.getDatabaseProductName.toLowerCase() match {
        case H2Dialect.regex() => H2Dialect
        case DerbyDialect.regex() => DerbyDialect
        case PostgresqlDialect.regex() => PostgresqlDialect
        case MysqlDialect.regex() => MysqlDialect
        case OracleDialect.regex() => OracleDialect
        case MssqlDialect.regex() => MssqlDialect
        case Db2Dialect.regex() => Db2Dialect
        case name => UnknownDialect(name)
      }
    }.get
}

abstract class JpaDialect(val name: String, val dialect: String) {
  val regex = name.r.unanchored
}

object H2Dialect extends JpaDialect("h2", "org.hibernate.dialect.H2Dialect")
object DerbyDialect extends JpaDialect("derby", "org.hibernate.dialect.DerbyDialect")
object PostgresqlDialect extends JpaDialect("postgres", "org.hibernate.dialect.PostgreSQLDialect")
object MysqlDialect extends JpaDialect("mysql", "org.hibernate.dialect.MySQLDialect")
object OracleDialect extends JpaDialect("oracle", "org.hibernate.dialect.OracleDialect")
object MssqlDialect extends JpaDialect("microsoft sql", "org.hibernate.dialect.SQLServerDialect")
object Db2Dialect extends JpaDialect("db2", "org.hibernate.dialect.DB2Dialect")
case class UnknownDialect(dbName: String) extends JpaDialect(".*", null)
