package ai.digital.deploy.permissions.model

import org.hibernate.envers.Audited

import jakarta.persistence.{Column, Entity, Table}

@Entity
@Table(name = "ps_global_role_permission")
@Audited
class GlobalPermission extends RoleFkModel {
  @Column(name = "permission_name")
  var permissionName: String = _

  override def toString = s"GlobalPermission($id, $role, $permissionName)"
}

object GlobalPermission {
  def apply(role: Role, permissionName: String): GlobalPermission = {
    val globalPermission = new GlobalPermission
    globalPermission.role = role
    globalPermission.permissionName = permissionName
    globalPermission
  }
}
