package ai.digital.deploy.permissions.model

import org.hibernate.annotations.{Cache, CacheConcurrencyStrategy}
import org.hibernate.envers.{Audited, NotAudited}

import java.util.{List => JList, UUID}
import jakarta.persistence.{Column, Entity, OneToMany, Table}
import scala.jdk.CollectionConverters._

@Entity
@Table(name = "ps_role")
@Audited
class Role extends BaseModel {
  @Column(name = "name", unique = true, nullable = false)
  var name: String = _

  @OneToMany(mappedBy = "role")
  @Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
  @NotAudited
  var principals: JList[RolePrincipal] = new java.util.ArrayList[RolePrincipal]()

  @OneToMany(mappedBy = "role")
  @NotAudited
  var referencedPermissions: JList[ReferencedPermission] = new java.util.ArrayList[ReferencedPermission]()

  @OneToMany(mappedBy = "role")
  @NotAudited
  var globalPermissions: JList[GlobalPermission] = new java.util.ArrayList[GlobalPermission]()

  // Setter methods - Always replace the entire collection!
  def setPrincipals(rolePrincipals: List[RolePrincipal]): Unit =
    if (null != rolePrincipals) {
      principals = new java.util.ArrayList[RolePrincipal](rolePrincipals.asJava)
    }

  def setReferencedPermissions(permissions: List[ReferencedPermission]): Unit =
    if (null != permissions) {
      referencedPermissions = new java.util.ArrayList[ReferencedPermission](permissions.asJava)
    }

  def setGlobalPermissions(permissions: List[GlobalPermission]): Unit =
    if (null != permissions) {
      globalPermissions = new java.util.ArrayList[GlobalPermission](permissions.asJava)
    }

  override def toString = s"Role($id, $name)"

  def canEqual(other: Any): Boolean =
    other match {
      case _: Role => true
      case _ => false
    }

  override def equals(other: Any): Boolean =
    other match {
      case that: Role =>
        (that canEqual this) &&
        name == that.name
      case _ => false
    }

  override def hashCode(): Int = {
    val state = Seq(name)
    state.map(_.hashCode()).foldLeft(0)((a, b) => 31 * a + b)
  }
}

object Role {
  def apply(name: String): Role = {
    val role = new Role
    role.name = name
    role
  }

  def apply(id: UUID, name: String): Role = {
    val role = new Role
    role.id = id
    role.name = name
    role
  }

  def apply(id: UUID,
            name: String,
            referencedPermissions: List[ReferencedPermission],
            globalPermissions: List[GlobalPermission]
  ): Role = {
    val role = new Role
    role.id = id
    role.name = name
    role.setReferencedPermissions(referencedPermissions)
    role.setGlobalPermissions(globalPermissions)
    role
  }

  def apply(id: UUID,
            name: String,
            principals: List[RolePrincipal],
            referencedPermissions: List[ReferencedPermission],
            globalPermissions: List[GlobalPermission]
  ): Role = {
    val role = new Role
    role.id = id
    role.name = name
    role.setPrincipals(principals)
    role.setReferencedPermissions(referencedPermissions)
    role.setGlobalPermissions(globalPermissions)
    role
  }
}
