package ai.digital.deploy.permissions.model.view

import ai.digital.deploy.permissions.model.converter.DateConverter
import org.hibernate.annotations.{Immutable, JdbcTypeCode}

import java.time.LocalDateTime
import java.util.UUID
import jakarta.persistence._
import java.sql.Types.VARCHAR

class ReferencedPermissionHistoryId extends Serializable {
  @Column(name = "referenced_permission_id")
  @JdbcTypeCode(VARCHAR)
  var referencedPermissionId: UUID = _

  @Column(name = "reference")
  @JdbcTypeCode(VARCHAR)
  var reference: UUID = _

  @Column(name = "start_time")
  @Convert(converter = classOf[DateConverter])
  var startTime: LocalDateTime = _
}

@Entity
@Immutable
@IdClass(classOf[ReferencedPermissionHistoryId])
@Table(name = "ps_referenced_permission_history")
class ReferencedPermissionHistory extends HistoryPermissionEntity {
  @Id
  @Column(name = "referenced_permission_id")
  @JdbcTypeCode(VARCHAR)
  var referencedPermissionId: UUID = _

  @Id
  @Column(name = "reference")
  @JdbcTypeCode(VARCHAR)
  var reference: UUID = _
}
