package ai.digital.deploy.permissions.repository.jpa

import ai.digital.deploy.permissions.jpa.TransactionalPermissionRepository
import ai.digital.deploy.permissions.model.view.{RolePrincipalReferenceView, RolePrincipalReferenceViewId}
import ai.digital.deploy.permissions.repository.RolePrincipalReferenceViewRepository
import org.springframework.data.jpa.repository.JpaRepository
import org.springframework.stereotype.Repository

import java.util.{List => JList, UUID}
import scala.jdk.CollectionConverters._

@Repository
@TransactionalPermissionRepository
trait RolePrincipalReferenceViewRepositoryImpl
    extends RolePrincipalReferenceViewRepository
    with JpaRepository[RolePrincipalReferenceView, RolePrincipalReferenceViewId] {
  override def get(referenceId: UUID): List[RolePrincipalReferenceView] = findByReference(referenceId).asScala.toList
  override def get(roleIds: List[UUID], referenceId: UUID): List[RolePrincipalReferenceView] =
    findByRoleIdInAndReference(roleIds.asJava, referenceId).asScala.toList

  protected def findByReference(referenceId: UUID): JList[RolePrincipalReferenceView]
  protected def findByRoleIdInAndReference(roleId: JList[UUID], reference: UUID): JList[RolePrincipalReferenceView]
}
