package ai.digital.deploy.permissions.service

import ai.digital.deploy.permissions.model.view.RoleReferencedPermissionView
import ai.digital.deploy.permissions.model.{ReferencedPermission, Role}
import org.springframework.data.domain.{Page, Pageable}

import java.util.UUID

trait ReferencedPermissionService {
  def add(referenceId: UUID,
          roleName: String,
          permissions: List[String]
  ): Either[RoleNameNotFoundServiceException, (Role, List[ReferencedPermission])]
  def remove(referenceId: UUID,
             roleName: String,
             permissions: List[String]
  ): Either[RoleNameNotFoundServiceException, (Role, List[ReferencedPermission])]
  def removeForRole(role: Role): Unit
  def removeForReference(referenceId: UUID): Unit
  def removeAll(): Unit
  def read(roleName: String): Either[RoleNameNotFoundServiceException, List[ReferencedPermission]]
  def read(roleNames: List[String]): Either[RoleNameNotFoundServiceException, List[ReferencedPermission]]
  def read(referenceId: UUID, roleName: String): Either[RoleNameNotFoundServiceException, List[ReferencedPermission]]
  def read(referenceId: UUID, rolePattern: String, pageable: Pageable): (Page[Role], List[RoleReferencedPermissionView])
  def readForRolePattern(referenceId: UUID, rolePattern: String): List[ReferencedPermission]
  def edit(referenceId: UUID,
           roleName: String,
           permissionsToAdd: List[String],
           permissionToDelete: List[String]
  ): Either[RoleNameNotFoundServiceException, (Role, List[ReferencedPermission])]
  def getReferencesForRole(roleId: UUID, permissions: List[String]): Set[UUID]
  def getReferencesForRoles(roleId: List[UUID], permissions: List[String]): Set[UUID]
  def getReferencesForRoleName(roleName: String, permissions: List[String]): Set[UUID]
  def getReferencesForPrincipalName(principalName: String, permissions: List[String]): Set[UUID]
  def checkPermission(referenceId: UUID, permissions: List[String], allRoles: List[String]): Boolean
  def checkPermission(referenceId: UUID, permissions: List[String], allRoles: List[String], principals: List[String]): Boolean
}
