package com.xebialabs.deployit.plugin.context

import java.io.{PrintWriter, StringWriter}

import com.xebialabs.deployit.local.message.ProductName
import com.xebialabs.deployit.plugin.api.flow.{ExecutionContext, ITask}
import grizzled.slf4j.Logger

class PreviewExecutionContext() extends ExecutionContext {

  private val logBuilder = new StringBuilder
  val ERROR_PREFIX = "[ERROR]: "
  val stepLogger: Logger = Logger.apply(getClass)

  override def logOutput(output: String): Unit = logOutputRaw(output + "\n")

  override def logMsgOutput(productName: ProductName, key: String, args: Object*): Unit = {
    logOutputRaw(getMessage(productName, key, args: _*) + "\n")
  }

  override def logOutputRaw(output: String): Unit = {
    stepLogger.debug(output.stripSuffix("\n"))
    logBuilder.append(output)
  }

  override def logError(error: String): Unit = {
    logErrorRaw(error + "\n")
  }

  override def logErrorRaw(error: String): Unit = {
    logErrorRaw(error, None)
  }

  override def logError(error: String, t: Throwable): Unit = {
    logErrorRaw(error + "\n", Option(t))
  }

  private def logErrorRaw(error: String, t: Option[Throwable]): Unit = {
    t match {
      case Some(thr) => stepLogger.error(error.stripSuffix("\n"), thr)
      case None => stepLogger.error(error.stripSuffix("\n"))
    }
    appendErrorToLogRaw(error)
    t.foreach(logException)
  }

  private def appendErrorToLogRaw(error: String): Unit = logBuilder.append(ERROR_PREFIX).append(error)

  private def logException(t: Throwable): Unit = {
    val stringWriter: StringWriter = new StringWriter
    t.printStackTrace(new PrintWriter(stringWriter))
    stringWriter.toString.split("\n").foreach(s => logBuilder.append(ERROR_PREFIX).append(s).append("\n"))
  }

  override def getAttribute(name: String) = throw new UnsupportedOperationException

  override def setAttribute(name: String, value: Any): Unit = throw new UnsupportedOperationException

  override def getRepository = throw new UnsupportedOperationException

  override def getInspectionContext = throw new UnsupportedOperationException

  override def getTask: ITask = throw new UnsupportedOperationException

  def getLog: String = logBuilder.toString

}
