package com.xebialabs.deployit.plugin.steps

import com.xebialabs.deployit.plugin.api.flow.{ExecutionContext, Preview, PreviewStep, StepExitCode}
import com.xebialabs.deployit.plugin.api.rules.{StepMetadata, StepParameter}

import scala.beans.BeanProperty

@StepMetadata(name = "delete-ci")
class DeleteCiStep extends BaseStep with PreviewStep {

  @StepParameter(name = "id", description = "Configuration item to create", required = true)
  @BeanProperty val id: String = null

  override def getPreview: Preview = Preview.withContents(s"Deleting ci with id ${id}")

  override def execute(ctx: ExecutionContext): StepExitCode = {
    ctx.logOutput(s"Deleting Configuration Item with id ${id}")
    ctx.getRepository.delete(id)
    StepExitCode.SUCCESS
  }
}
